/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class AuthenticationSuccessResponse
extends AuthorizationSuccessResponse
implements AuthenticationResponse {
    private final JWT idToken;
    private final State sessionState;

    public AuthenticationSuccessResponse(URI redirectURI, AuthorizationCode code, JWT idToken, AccessToken accessToken, State state) {
        this(redirectURI, code, idToken, accessToken, state, null);
    }

    public AuthenticationSuccessResponse(URI redirectURI, AuthorizationCode code, JWT idToken, AccessToken accessToken, State state, State sessionState) {
        super(redirectURI, code, accessToken, state);
        this.idToken = idToken;
        this.sessionState = sessionState;
    }

    @Override
    public ResponseType impliedResponseType() {
        ResponseType rt = new ResponseType();
        if (this.getAuthorizationCode() != null) {
            rt.add(ResponseType.Value.CODE);
        }
        if (this.getIDToken() != null) {
            rt.add(OIDCResponseTypeValue.ID_TOKEN);
        }
        if (this.getAccessToken() != null) {
            rt.add(ResponseType.Value.TOKEN);
        }
        return rt;
    }

    public JWT getIDToken() {
        return this.idToken;
    }

    public State getSessionState() {
        return this.sessionState;
    }

    @Override
    public Map<String, String> toParameters() throws SerializeException {
        Map<String, String> params = super.toParameters();
        if (this.idToken != null) {
            try {
                params.put("id_token", this.idToken.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize ID token: " + e.getMessage(), e);
            }
        }
        if (this.sessionState != null) {
            params.put("session_state", this.sessionState.getValue());
        }
        return params;
    }

    @Override
    public URI toURI() throws SerializeException {
        StringBuilder sb = new StringBuilder(this.getRedirectionURI().toString());
        if (this.idToken != null || this.getAccessToken() != null) {
            sb.append('#');
        } else {
            sb.append('?');
        }
        sb.append(URLUtils.serializeParameters(this.toParameters()));
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new SerializeException("Couldn't serialize response: " + e.getMessage(), e);
        }
    }

    public static AuthenticationSuccessResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        AuthorizationSuccessResponse asr = AuthorizationSuccessResponse.parse(redirectURI, params);
        JWT idToken = null;
        if (params.get("id_token") != null) {
            try {
                idToken = JWTParser.parse((String)params.get("id_token"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid ID Token JWT: " + e.getMessage(), e);
            }
        }
        State sessionState = null;
        if (StringUtils.isNotBlank((CharSequence)params.get("session_state"))) {
            sessionState = new State(params.get("session_state"));
        }
        return new AuthenticationSuccessResponse(redirectURI, asr.getAuthorizationCode(), idToken, asr.getAccessToken(), asr.getState(), sessionState);
    }

    public static AuthenticationSuccessResponse parse(URI uri) throws ParseException {
        String paramString;
        if (uri.getRawQuery() != null) {
            paramString = uri.getRawQuery();
        } else if (uri.getRawFragment() != null) {
            paramString = uri.getRawFragment();
        } else {
            throw new ParseException("Missing authorization response parameters");
        }
        Map<String, String> params = URLUtils.parseParameters(paramString);
        if (params == null) {
            throw new ParseException("Missing or invalid authorization response parameters");
        }
        return AuthenticationSuccessResponse.parse(URIUtils.getBaseURI(uri), params);
    }

    public static AuthenticationSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 302) {
            throw new ParseException("Unexpected HTTP status code, must be 302 (Found): " + httpResponse.getStatusCode());
        }
        URI location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthenticationSuccessResponse.parse(location);
    }
}

