/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPMessage;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class HTTPRequest
extends HTTPMessage {
    private final Method method;
    private final URL url;
    private String authorization = null;
    private String query = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;

    public HTTPRequest(Method method, URL url) {
        if (method == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.method = method;
        if (url == null) {
            throw new IllegalArgumentException("The HTTP URL must not be null");
        }
        this.url = url;
    }

    private static String reconstructRequestURLString(HttpServletRequest request) {
        String path;
        StringBuilder sb = new StringBuilder("http");
        if (request.isSecure()) {
            sb.append('s');
        }
        sb.append("://");
        String localAddress = request.getLocalAddr();
        if (localAddress.contains(".")) {
            sb.append(localAddress);
        } else if (localAddress.contains(":")) {
            sb.append('[');
            sb.append(localAddress);
            sb.append(']');
        }
        if (!request.isSecure() && request.getLocalPort() != 80) {
            sb.append(':');
            sb.append(request.getLocalPort());
        }
        if (request.isSecure() && request.getLocalPort() != 443) {
            sb.append(':');
            sb.append(request.getLocalPort());
        }
        if ((path = request.getRequestURI()) != null) {
            sb.append(path);
        }
        return sb.toString();
    }

    public HTTPRequest(HttpServletRequest sr) throws IOException {
        this.method = Method.valueOf(sr.getMethod().toUpperCase());
        String urlString = HTTPRequest.reconstructRequestURLString(sr);
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid request URL: " + e.getMessage() + ": " + urlString, e);
        }
        try {
            this.setContentType(sr.getContentType());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid Content-Type header value: " + e.getMessage(), e);
        }
        this.setAuthorization(sr.getHeader("Authorization"));
        if (this.method.equals((Object)Method.GET) || this.method.equals((Object)Method.DELETE)) {
            this.setQuery(sr.getQueryString());
        } else if (this.method.equals((Object)Method.POST) || this.method.equals((Object)Method.PUT)) {
            String line;
            StringBuilder body = new StringBuilder(256);
            BufferedReader reader = sr.getReader();
            boolean firstLine = true;
            while ((line = reader.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    body.append(System.getProperty("line.separator"));
                }
                body.append(line);
            }
            reader.close();
            this.setQuery(body.toString());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public void ensureMethod(Method expectedMethod) throws ParseException {
        if (this.method != expectedMethod) {
            throw new ParseException("The HTTP request method must be " + (Object)((Object)expectedMethod));
        }
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authz) {
        this.authorization = authz;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private void ensureQuery() throws ParseException {
        if (this.query == null || this.query.trim().isEmpty()) {
            throw new ParseException("Missing or empty HTTP query string / entity body");
        }
    }

    public Map<String, String> getQueryParameters() {
        return URLUtils.parseParameters(this.query);
    }

    public JSONObject getQueryAsJSONObject() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JSON);
        this.ensureQuery();
        return JSONObjectUtils.parseJSONObject(this.query);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("The HTTP connect timeout must be zero or positive");
        }
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("The HTTP response read timeout must be zero or positive");
        }
        this.readTimeout = readTimeout;
    }

    public HttpURLConnection toHttpURLConnection() throws IOException {
        URL finalURL = this.url;
        if (this.query != null && (this.method.equals((Object)Method.GET) || this.method.equals((Object)Method.DELETE))) {
            StringBuilder sb = new StringBuilder(this.url.toString());
            sb.append('?');
            sb.append(this.query);
            try {
                finalURL = new URL(sb.toString());
            }
            catch (MalformedURLException e) {
                throw new IOException("Couldn't append query string: " + e.getMessage(), e);
            }
        }
        HttpURLConnection conn = (HttpURLConnection)finalURL.openConnection();
        if (this.authorization != null) {
            conn.setRequestProperty("Authorization", this.authorization);
        }
        conn.setRequestMethod(this.method.name());
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        if (this.method.equals((Object)Method.POST) || this.method.equals((Object)Method.PUT)) {
            conn.setDoOutput(true);
            if (this.getContentType() != null) {
                conn.setRequestProperty("Content-Type", this.getContentType().toString());
            }
            if (this.query != null) {
                OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
                writer.write(this.query);
                writer.close();
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse send() throws IOException {
        int statusCode;
        BufferedReader reader;
        HttpURLConnection conn = this.toHttpURLConnection();
        try {
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            statusCode = conn.getResponseCode();
        }
        catch (IOException e) {
            statusCode = conn.getResponseCode();
            if (statusCode == -1) {
                throw e;
            }
            InputStream errStream = conn.getErrorStream();
            reader = errStream != null ? new BufferedReader(new InputStreamReader(errStream)) : new BufferedReader(new StringReader(""));
        }
        StringBuilder body = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                body.append(line);
                body.append(System.getProperty("line.separator"));
            }
            reader.close();
        }
        finally {
            conn.disconnect();
        }
        HTTPResponse response = new HTTPResponse(statusCode);
        String location = conn.getHeaderField("Location");
        if (location != null) {
            try {
                response.setLocation(new URI(location));
            }
            catch (URISyntaxException e) {
                throw new IOException("Couldn't parse Location header: " + e.getMessage(), e);
            }
        }
        try {
            response.setContentType(conn.getContentType());
        }
        catch (ParseException e) {
            throw new IOException("Couldn't parse Content-Type header: " + e.getMessage(), e);
        }
        response.setCacheControl(conn.getHeaderField("Cache-Control"));
        response.setPragma(conn.getHeaderField("Pragma"));
        response.setWWWAuthenticate(conn.getHeaderField("WWW-Authenticate"));
        String bodyContent = body.toString();
        if (!bodyContent.isEmpty()) {
            response.setContent(bodyContent);
        }
        return response;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

