/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.net.URI;
import java.util.Map;

public class AuthenticationResponseParser {
    public static AuthenticationResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        if (params.containsKey("error")) {
            return AuthenticationErrorResponse.parse(redirectURI, params);
        }
        return AuthenticationSuccessResponse.parse(redirectURI, params);
    }

    public static AuthenticationResponse parse(URI uri) throws ParseException {
        String paramString;
        if (uri.getRawQuery() != null) {
            paramString = uri.getRawQuery();
        } else if (uri.getRawFragment() != null) {
            paramString = uri.getRawFragment();
        } else {
            throw new ParseException("Missing authorization response parameters");
        }
        Map<String, String> params = URLUtils.parseParameters(paramString);
        if (params == null) {
            throw new ParseException("Missing or invalid authorization response parameters");
        }
        return AuthenticationResponseParser.parse(URIUtils.getBaseURI(uri), params);
    }

    public static AuthenticationResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 302) {
            throw new ParseException("Unexpected HTTP status code, must be 302 (Found): " + httpResponse.getStatusCode());
        }
        URI location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthenticationResponseParser.parse(location);
    }

    private AuthenticationResponseParser() {
    }
}

