/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.TokenPair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class AccessTokenResponse
extends TokenResponse
implements SuccessResponse {
    private final AccessToken accessToken;
    private final RefreshToken refreshToken;
    private final Map<String, Object> customParams;

    public AccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken) {
        this(accessToken, refreshToken, null);
    }

    public AccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, Map<String, Object> customParams) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.customParams = customParams;
    }

    public AccessTokenResponse(TokenPair tokenPair) {
        this(tokenPair, null);
    }

    public AccessTokenResponse(TokenPair tokenPair, Map<String, Object> customParams) {
        this(tokenPair.getAccessToken(), tokenPair.getRefreshToken(), customParams);
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public TokenPair getTokenPair() {
        return new TokenPair(this.accessToken, this.refreshToken);
    }

    public Map<String, Object> getCustomParams() {
        if (this.customParams == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customParams);
    }

    public JSONObject toJSONObject() throws SerializeException {
        JSONObject o = this.accessToken.toJSONObject();
        if (this.refreshToken != null) {
            o.putAll((Map)this.refreshToken.toJSONObject());
        }
        if (this.customParams != null) {
            o.putAll(this.customParams);
        }
        return o;
    }

    @Override
    public HTTPResponse toHTTPResponse() throws SerializeException {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        httpResponse.setContent(this.toJSONObject().toString());
        return httpResponse;
    }

    public static AccessTokenResponse parse(JSONObject jsonObject) throws ParseException {
        AccessToken accessToken = AccessToken.parse(jsonObject);
        RefreshToken refreshToken = RefreshToken.parse(jsonObject);
        Set<String> paramNames = accessToken.getParamNames();
        if (refreshToken != null) {
            paramNames.addAll(refreshToken.getParamNames());
        }
        Set customParamNames = jsonObject.keySet();
        customParamNames.removeAll(paramNames);
        HashMap<String, Object> customParams = null;
        if (customParamNames.size() > 0) {
            customParams = new HashMap<String, Object>();
            for (String name : customParamNames) {
                customParams.put(name, jsonObject.get((Object)name));
            }
        }
        return new AccessTokenResponse(accessToken, refreshToken, customParams);
    }

    public static AccessTokenResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return AccessTokenResponse.parse(jsonObject);
    }
}

