/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.jose.jwk.AbstractJWKSelectorWithSource;
import com.nimbusds.oauth2.sdk.jose.jwk.JWKSource;
import com.nimbusds.oauth2.sdk.jose.jwk.KeyConverter;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWSVerificationKeySelector
extends AbstractJWKSelectorWithSource
implements JWSKeySelector {
    private final JWSAlgorithm jwsAlg;

    public JWSVerificationKeySelector(Identifier id, JWSAlgorithm jwsAlg, JWKSource jwkSource) {
        super(id, jwkSource);
        if (jwsAlg == null) {
            throw new IllegalArgumentException("The JWS algorithm must not be null");
        }
        this.jwsAlg = jwsAlg;
    }

    public JWSAlgorithm getExpectedJWSAlgorithm() {
        return this.jwsAlg;
    }

    protected JWKMatcher createJWKMatcher(JWSHeader jwsHeader) {
        if (JWSAlgorithm.Family.RSA.contains((Object)this.getExpectedJWSAlgorithm()) || JWSAlgorithm.Family.EC.contains((Object)this.getExpectedJWSAlgorithm())) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)this.getExpectedJWSAlgorithm())).keyID(jwsHeader.getKeyID()).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).algorithms(new Algorithm[]{this.getExpectedJWSAlgorithm(), null}).build();
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)this.getExpectedJWSAlgorithm())) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)this.getExpectedJWSAlgorithm())).privateOnly(true).algorithms(new Algorithm[]{this.getExpectedJWSAlgorithm(), null}).build();
        }
        return null;
    }

    public List<? extends Key> selectJWSKeys(JWSHeader jwsHeader, SecurityContext context) {
        if (!this.jwsAlg.equals((Object)jwsHeader.getAlgorithm())) {
            return Collections.emptyList();
        }
        JWKMatcher jwkMatcher = this.createJWKMatcher(jwsHeader);
        if (jwkMatcher == null) {
            return Collections.emptyList();
        }
        List<JWK> jwkMatches = this.getJWKSource().get(this.getIdentifier(), new JWKSelector(jwkMatcher));
        return KeyConverter.toJavaKeys(jwkMatches);
    }
}

