/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public class OIDCProviderMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Issuer issuer;
    private URI authzEndpoint;
    private URI tokenEndpoint;
    private URI userInfoEndpoint;
    private URI regEndpoint;
    private URI checkSessionIframe;
    private URI endSessionEndpoint;
    private final URI jwkSetURI;
    private Scope scope;
    private List<ResponseType> rts;
    private List<ResponseMode> rms;
    private List<GrantType> gts;
    private List<ACR> acrValues;
    private final List<SubjectType> subjectTypes;
    private List<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private List<JWSAlgorithm> tokenEndpointJWSAlgs;
    private List<JWSAlgorithm> requestObjectJWSAlgs;
    private List<JWEAlgorithm> requestObjectJWEAlgs;
    private List<EncryptionMethod> requestObjectJWEEncs;
    private List<JWSAlgorithm> idTokenJWSAlgs;
    private List<JWEAlgorithm> idTokenJWEAlgs;
    private List<EncryptionMethod> idTokenJWEEncs;
    private List<JWSAlgorithm> userInfoJWSAlgs;
    private List<JWEAlgorithm> userInfoJWEAlgs;
    private List<EncryptionMethod> userInfoJWEEncs;
    private List<Display> displays;
    private List<ClaimType> claimTypes;
    private List<String> claims;
    private List<LangTag> claimsLocales;
    private List<LangTag> uiLocales;
    private URI serviceDocsURI;
    private URI policyURI;
    private URI tosURI;
    private boolean claimsParamSupported = false;
    private boolean requestParamSupported = false;
    private boolean requestURIParamSupported = true;
    private boolean requireRequestURIReg = false;
    private final JSONObject customParameters = new JSONObject();

    public OIDCProviderMetadata(Issuer issuer, List<SubjectType> subjectTypes, URI jwkSetURI) {
        URI url;
        try {
            url = new URI(issuer.getValue());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The issuer identifier must be a URI: " + e.getMessage(), e);
        }
        if (url.getRawQuery() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a query component");
        }
        if (url.getRawFragment() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a fragment component ");
        }
        this.issuer = issuer;
        if (subjectTypes.size() < 1) {
            throw new IllegalArgumentException("At least one supported subject type must be specified");
        }
        this.subjectTypes = subjectTypes;
        if (jwkSetURI == null) {
            throw new IllegalArgumentException("The public JWK set URI must not be null");
        }
        this.jwkSetURI = jwkSetURI;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public URI getAuthorizationEndpointURI() {
        return this.authzEndpoint;
    }

    public void setAuthorizationEndpointURI(URI authzEndpoint) {
        this.authzEndpoint = authzEndpoint;
    }

    public URI getTokenEndpointURI() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpointURI(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public URI getUserInfoEndpointURI() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpointURI(URI userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public URI getRegistrationEndpointURI() {
        return this.regEndpoint;
    }

    public void setRegistrationEndpointURI(URI regEndpoint) {
        this.regEndpoint = regEndpoint;
    }

    public URI getCheckSessionIframeURI() {
        return this.checkSessionIframe;
    }

    public void setCheckSessionIframeURI(URI checkSessionIframe) {
        this.checkSessionIframe = checkSessionIframe;
    }

    public URI getEndSessionEndpointURI() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpointURI(URI endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public Scope getScopes() {
        return this.scope;
    }

    public void setScopes(Scope scope) {
        this.scope = scope;
    }

    public List<ResponseType> getResponseTypes() {
        return this.rts;
    }

    public void setResponseTypes(List<ResponseType> rts) {
        this.rts = rts;
    }

    public List<ResponseMode> getResponseModes() {
        return this.rms;
    }

    public void setResponseModes(List<ResponseMode> rms) {
        this.rms = rms;
    }

    public List<GrantType> getGrantTypes() {
        return this.gts;
    }

    public void setGrantTypes(List<GrantType> gts) {
        this.gts = gts;
    }

    public List<ACR> getACRs() {
        return this.acrValues;
    }

    public void setACRs(List<ACR> acrValues) {
        this.acrValues = acrValues;
    }

    public List<SubjectType> getSubjectTypes() {
        return this.subjectTypes;
    }

    public List<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public void setTokenEndpointAuthMethods(List<ClientAuthenticationMethod> tokenEndpointAuthMethods) {
        this.tokenEndpointAuthMethods = tokenEndpointAuthMethods;
    }

    public List<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public void setTokenEndpointJWSAlgs(List<JWSAlgorithm> tokenEndpointJWSAlgs) {
        if (tokenEndpointJWSAlgs != null && tokenEndpointJWSAlgs.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The none algorithm is not accepted");
        }
        this.tokenEndpointJWSAlgs = tokenEndpointJWSAlgs;
    }

    public List<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public void setRequestObjectJWSAlgs(List<JWSAlgorithm> requestObjectJWSAlgs) {
        this.requestObjectJWSAlgs = requestObjectJWSAlgs;
    }

    public List<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public void setRequestObjectJWEAlgs(List<JWEAlgorithm> requestObjectJWEAlgs) {
        this.requestObjectJWEAlgs = requestObjectJWEAlgs;
    }

    public List<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public void setRequestObjectJWEEncs(List<EncryptionMethod> requestObjectJWEEncs) {
        this.requestObjectJWEEncs = requestObjectJWEEncs;
    }

    public List<JWSAlgorithm> getIDTokenJWSAlgs() {
        return this.idTokenJWSAlgs;
    }

    public void setIDTokenJWSAlgs(List<JWSAlgorithm> idTokenJWSAlgs) {
        this.idTokenJWSAlgs = idTokenJWSAlgs;
    }

    public List<JWEAlgorithm> getIDTokenJWEAlgs() {
        return this.idTokenJWEAlgs;
    }

    public void setIDTokenJWEAlgs(List<JWEAlgorithm> idTokenJWEAlgs) {
        this.idTokenJWEAlgs = idTokenJWEAlgs;
    }

    public List<EncryptionMethod> getIDTokenJWEEncs() {
        return this.idTokenJWEEncs;
    }

    public void setIDTokenJWEEncs(List<EncryptionMethod> idTokenJWEEncs) {
        this.idTokenJWEEncs = idTokenJWEEncs;
    }

    public List<JWSAlgorithm> getUserInfoJWSAlgs() {
        return this.userInfoJWSAlgs;
    }

    public void setUserInfoJWSAlgs(List<JWSAlgorithm> userInfoJWSAlgs) {
        this.userInfoJWSAlgs = userInfoJWSAlgs;
    }

    public List<JWEAlgorithm> getUserInfoJWEAlgs() {
        return this.userInfoJWEAlgs;
    }

    public void setUserInfoJWEAlgs(List<JWEAlgorithm> userInfoJWEAlgs) {
        this.userInfoJWEAlgs = userInfoJWEAlgs;
    }

    public List<EncryptionMethod> getUserInfoJWEEncs() {
        return this.userInfoJWEEncs;
    }

    public void setUserInfoJWEEncs(List<EncryptionMethod> userInfoJWEEncs) {
        this.userInfoJWEEncs = userInfoJWEEncs;
    }

    public List<Display> getDisplays() {
        return this.displays;
    }

    public void setDisplays(List<Display> displays) {
        this.displays = displays;
    }

    public List<ClaimType> getClaimTypes() {
        return this.claimTypes;
    }

    public void setClaimTypes(List<ClaimType> claimTypes) {
        this.claimTypes = claimTypes;
    }

    public List<String> getClaims() {
        return this.claims;
    }

    public void setClaims(List<String> claims) {
        this.claims = claims;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimLocales(List<LangTag> claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public void setUILocales(List<LangTag> uiLocales) {
        this.uiLocales = uiLocales;
    }

    public URI getServiceDocsURI() {
        return this.serviceDocsURI;
    }

    public void setServiceDocsURI(URI serviceDocsURI) {
        this.serviceDocsURI = serviceDocsURI;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI policyURI) {
        this.policyURI = policyURI;
    }

    public URI getTermsOfServiceURI() {
        return this.tosURI;
    }

    public void setTermsOfServiceURI(URI tosURI) {
        this.tosURI = tosURI;
    }

    public boolean supportsClaimsParam() {
        return this.claimsParamSupported;
    }

    public void setSupportsClaimsParams(boolean claimsParamSupported) {
        this.claimsParamSupported = claimsParamSupported;
    }

    public boolean supportsRequestParam() {
        return this.requestParamSupported;
    }

    public void setSupportsRequestParam(boolean requestParamSupported) {
        this.requestParamSupported = requestParamSupported;
    }

    public boolean supportsRequestURIParam() {
        return this.requestURIParamSupported;
    }

    public void setSupportsRequestURIParam(boolean requestURIParamSupported) {
        this.requestURIParamSupported = requestURIParamSupported;
    }

    public boolean requiresRequestURIRegistration() {
        return this.requireRequestURIReg;
    }

    public void setRequiresRequestURIRegistration(boolean requireRequestURIReg) {
        this.requireRequestURIReg = requireRequestURIReg;
    }

    public Object getCustomParameter(String name) {
        return this.customParameters.get((Object)name);
    }

    public URI getCustomURIParameter(String name) {
        try {
            return JSONObjectUtils.getURI(this.customParameters, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setCustomParameter(String name, Object value) {
        if (REGISTERED_PARAMETER_NAMES.contains(name)) {
            throw new IllegalArgumentException("The " + name + " parameter is registered");
        }
        this.customParameters.put((Object)name, value);
    }

    public JSONObject getCustomParameters() {
        return this.customParameters;
    }

    public void applyDefaults() {
        if (this.rms == null) {
            this.rms = new ArrayList<ResponseMode>(2);
            this.rms.add(ResponseMode.QUERY);
            this.rms.add(ResponseMode.FRAGMENT);
        }
        if (this.gts == null) {
            this.gts = new ArrayList<GrantType>(2);
            this.gts.add(GrantType.AUTHORIZATION_CODE);
            this.gts.add(GrantType.IMPLICIT);
        }
        if (this.claimTypes == null) {
            this.claimTypes = new ArrayList<ClaimType>(1);
            this.claimTypes.add(ClaimType.NORMAL);
        }
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"issuer", (Object)this.issuer.getValue());
        ArrayList<String> stringList = new ArrayList<String>(this.subjectTypes.size());
        for (SubjectType subjectType : this.subjectTypes) {
            stringList.add(subjectType.toString());
        }
        o.put((Object)"subject_types_supported", stringList);
        o.put((Object)"jwks_uri", (Object)this.jwkSetURI.toString());
        if (this.authzEndpoint != null) {
            o.put((Object)"authorization_endpoint", (Object)this.authzEndpoint.toString());
        }
        if (this.tokenEndpoint != null) {
            o.put((Object)"token_endpoint", (Object)this.tokenEndpoint.toString());
        }
        if (this.userInfoEndpoint != null) {
            o.put((Object)"userinfo_endpoint", (Object)this.userInfoEndpoint.toString());
        }
        if (this.regEndpoint != null) {
            o.put((Object)"registration_endpoint", (Object)this.regEndpoint.toString());
        }
        if (this.checkSessionIframe != null) {
            o.put((Object)"check_session_iframe", (Object)this.checkSessionIframe.toString());
        }
        if (this.endSessionEndpoint != null) {
            o.put((Object)"end_session_endpoint", (Object)this.endSessionEndpoint.toString());
        }
        if (this.scope != null) {
            o.put((Object)"scopes_supported", this.scope.toStringList());
        }
        if (this.rts != null) {
            stringList = new ArrayList(this.rts.size());
            for (ResponseType responseType : this.rts) {
                stringList.add(responseType.toString());
            }
            o.put((Object)"response_types_supported", stringList);
        }
        if (this.rms != null) {
            stringList = new ArrayList(this.rms.size());
            for (ResponseMode responseMode : this.rms) {
                stringList.add(responseMode.getValue());
            }
            o.put((Object)"response_modes_supported", stringList);
        }
        if (this.gts != null) {
            stringList = new ArrayList(this.gts.size());
            for (GrantType grantType : this.gts) {
                stringList.add(grantType.toString());
            }
            o.put((Object)"grant_types_supported", stringList);
        }
        if (this.acrValues != null) {
            stringList = new ArrayList(this.acrValues.size());
            for (ACR aCR : this.acrValues) {
                stringList.add(aCR.getValue());
            }
            o.put((Object)"acr_values_supported", stringList);
        }
        if (this.tokenEndpointAuthMethods != null) {
            stringList = new ArrayList(this.tokenEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.tokenEndpointAuthMethods) {
                stringList.add(clientAuthenticationMethod.getValue());
            }
            o.put((Object)"token_endpoint_auth_methods_supported", stringList);
        }
        if (this.tokenEndpointJWSAlgs != null) {
            stringList = new ArrayList(this.tokenEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.tokenEndpointJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"token_endpoint_auth_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWSAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.requestObjectJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"request_object_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.requestObjectJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put((Object)"request_object_encryption_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEEncs != null) {
            stringList = new ArrayList(this.requestObjectJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.requestObjectJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put((Object)"request_object_encryption_enc_values_supported", stringList);
        }
        if (this.idTokenJWSAlgs != null) {
            stringList = new ArrayList(this.idTokenJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.idTokenJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"id_token_signing_alg_values_supported", stringList);
        }
        if (this.idTokenJWEAlgs != null) {
            stringList = new ArrayList(this.idTokenJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.idTokenJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put((Object)"id_token_encryption_alg_values_supported", stringList);
        }
        if (this.idTokenJWEEncs != null) {
            stringList = new ArrayList(this.idTokenJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.idTokenJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put((Object)"id_token_encryption_enc_values_supported", stringList);
        }
        if (this.userInfoJWSAlgs != null) {
            stringList = new ArrayList(this.userInfoJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.userInfoJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put((Object)"userinfo_signing_alg_values_supported", stringList);
        }
        if (this.userInfoJWEAlgs != null) {
            stringList = new ArrayList(this.userInfoJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.userInfoJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put((Object)"userinfo_encryption_alg_values_supported", stringList);
        }
        if (this.userInfoJWEEncs != null) {
            stringList = new ArrayList(this.userInfoJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.userInfoJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put((Object)"userinfo_encryption_enc_values_supported", stringList);
        }
        if (this.displays != null) {
            stringList = new ArrayList(this.displays.size());
            for (Display display : this.displays) {
                stringList.add(display.toString());
            }
            o.put((Object)"display_values_supported", stringList);
        }
        if (this.claimTypes != null) {
            stringList = new ArrayList(this.claimTypes.size());
            for (ClaimType claimType : this.claimTypes) {
                stringList.add(claimType.toString());
            }
            o.put((Object)"claim_types_supported", stringList);
        }
        if (this.claims != null) {
            o.put((Object)"claims_supported", this.claims);
        }
        if (this.claimsLocales != null) {
            stringList = new ArrayList(this.claimsLocales.size());
            for (LangTag langTag : this.claimsLocales) {
                stringList.add(langTag.toString());
            }
            o.put((Object)"claims_locales_supported", stringList);
        }
        if (this.uiLocales != null) {
            stringList = new ArrayList(this.uiLocales.size());
            for (LangTag langTag : this.uiLocales) {
                stringList.add(langTag.toString());
            }
            o.put((Object)"ui_locales_supported", stringList);
        }
        if (this.serviceDocsURI != null) {
            o.put((Object)"service_documentation", (Object)this.serviceDocsURI.toString());
        }
        if (this.policyURI != null) {
            o.put((Object)"op_policy_uri", (Object)this.policyURI.toString());
        }
        if (this.tosURI != null) {
            o.put((Object)"op_tos_uri", (Object)this.tosURI.toString());
        }
        o.put((Object)"claims_parameter_supported", (Object)this.claimsParamSupported);
        o.put((Object)"request_parameter_supported", (Object)this.requestParamSupported);
        o.put((Object)"request_uri_parameter_supported", (Object)this.requestURIParamSupported);
        o.put((Object)"require_request_uri_registration", (Object)this.requireRequestURIReg);
        o.putAll((Map)this.customParameters);
        return o;
    }

    public static OIDCProviderMetadata parse(JSONObject jsonObject) throws ParseException {
        ArrayList<SubjectType> subjectTypes = new ArrayList<SubjectType>();
        for (String v : JSONObjectUtils.getStringArray(jsonObject, "subject_types_supported")) {
            subjectTypes.add(SubjectType.parse(v));
        }
        Issuer issuer = new Issuer(JSONObjectUtils.getURI(jsonObject, "issuer").toString());
        URI jwkSetURI = JSONObjectUtils.getURI(jsonObject, "jwks_uri");
        OIDCProviderMetadata op = new OIDCProviderMetadata(issuer, Collections.unmodifiableList(subjectTypes), jwkSetURI);
        if (jsonObject.containsKey((Object)"authorization_endpoint")) {
            op.authzEndpoint = JSONObjectUtils.getURI(jsonObject, "authorization_endpoint");
        }
        if (jsonObject.containsKey((Object)"token_endpoint")) {
            op.tokenEndpoint = JSONObjectUtils.getURI(jsonObject, "token_endpoint");
        }
        if (jsonObject.containsKey((Object)"userinfo_endpoint")) {
            op.userInfoEndpoint = JSONObjectUtils.getURI(jsonObject, "userinfo_endpoint");
        }
        if (jsonObject.containsKey((Object)"registration_endpoint")) {
            op.regEndpoint = JSONObjectUtils.getURI(jsonObject, "registration_endpoint");
        }
        if (jsonObject.containsKey((Object)"check_session_iframe")) {
            op.checkSessionIframe = JSONObjectUtils.getURI(jsonObject, "check_session_iframe");
        }
        if (jsonObject.containsKey((Object)"end_session_endpoint")) {
            op.endSessionEndpoint = JSONObjectUtils.getURI(jsonObject, "end_session_endpoint");
        }
        if (jsonObject.containsKey((Object)"scopes_supported")) {
            op.scope = new Scope();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "scopes_supported")) {
                if (v == null) continue;
                op.scope.add(new Scope.Value(v));
            }
        }
        if (jsonObject.containsKey((Object)"response_types_supported")) {
            op.rts = new ArrayList<ResponseType>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "response_types_supported")) {
                if (v == null) continue;
                op.rts.add(ResponseType.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"response_modes_supported")) {
            op.rms = new ArrayList<ResponseMode>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "response_modes_supported")) {
                if (v == null) continue;
                op.rms.add(new ResponseMode(v));
            }
        }
        if (jsonObject.containsKey((Object)"grant_types_supported")) {
            op.gts = new ArrayList<GrantType>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "grant_types_supported")) {
                if (v == null) continue;
                op.gts.add(GrantType.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"acr_values_supported")) {
            op.acrValues = new ArrayList<ACR>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "acr_values_supported")) {
                if (v == null) continue;
                op.acrValues.add(new ACR(v));
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_methods_supported")) {
            op.tokenEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_methods_supported")) {
                if (v == null) continue;
                op.tokenEndpointAuthMethods.add(new ClientAuthenticationMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"token_endpoint_auth_signing_alg_values_supported")) {
            op.tokenEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_signing_alg_values_supported")) {
                if (v != null && v.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (v == null) continue;
                op.tokenEndpointJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_signing_alg_values_supported")) {
            op.requestObjectJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "request_object_signing_alg_values_supported")) {
                if (v == null) continue;
                op.requestObjectJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_alg_values_supported")) {
            op.requestObjectJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_alg_values_supported")) {
                if (v == null) continue;
                op.requestObjectJWEAlgs.add(new JWEAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"request_object_encryption_enc_values_supported")) {
            op.requestObjectJWEEncs = new ArrayList<EncryptionMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_enc_values_supported")) {
                if (v == null) continue;
                op.requestObjectJWEEncs.add(new EncryptionMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_signing_alg_values_supported")) {
            op.idTokenJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "id_token_signing_alg_values_supported")) {
                if (v == null) continue;
                op.idTokenJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_alg_values_supported")) {
            op.idTokenJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_alg_values_supported")) {
                if (v == null) continue;
                op.idTokenJWEAlgs.add(new JWEAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"id_token_encryption_enc_values_supported")) {
            op.idTokenJWEEncs = new ArrayList<EncryptionMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "id_token_encryption_enc_values_supported")) {
                if (v == null) continue;
                op.idTokenJWEEncs.add(new EncryptionMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_signing_alg_values_supported")) {
            op.userInfoJWSAlgs = new ArrayList<JWSAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "userinfo_signing_alg_values_supported")) {
                if (v == null) continue;
                op.userInfoJWSAlgs.add(new JWSAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_alg_values_supported")) {
            op.userInfoJWEAlgs = new ArrayList<JWEAlgorithm>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_alg_values_supported")) {
                if (v == null) continue;
                op.userInfoJWEAlgs.add(new JWEAlgorithm(v));
            }
        }
        if (jsonObject.containsKey((Object)"userinfo_encryption_enc_values_supported")) {
            op.userInfoJWEEncs = new ArrayList<EncryptionMethod>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "userinfo_encryption_enc_values_supported")) {
                if (v == null) continue;
                op.userInfoJWEEncs.add(new EncryptionMethod(v));
            }
        }
        if (jsonObject.containsKey((Object)"display_values_supported")) {
            op.displays = new ArrayList<Display>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "display_values_supported")) {
                if (v == null) continue;
                op.displays.add(Display.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"claim_types_supported")) {
            op.claimTypes = new ArrayList<ClaimType>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "claim_types_supported")) {
                if (v == null) continue;
                op.claimTypes.add(ClaimType.parse(v));
            }
        }
        if (jsonObject.containsKey((Object)"claims_supported")) {
            op.claims = new ArrayList<String>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "claims_supported")) {
                if (v == null) continue;
                op.claims.add(v);
            }
        }
        if (jsonObject.containsKey((Object)"claims_locales_supported")) {
            op.claimsLocales = new ArrayList<LangTag>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "claims_locales_supported")) {
                if (v == null) continue;
                try {
                    op.claimsLocales.add(LangTag.parse((String)v));
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid claims_locales_supported field: " + e.getMessage(), e);
                }
            }
        }
        if (jsonObject.containsKey((Object)"ui_locales_supported")) {
            op.uiLocales = new ArrayList<LangTag>();
            for (String v : JSONObjectUtils.getStringArray(jsonObject, "ui_locales_supported")) {
                if (v == null) continue;
                try {
                    op.uiLocales.add(LangTag.parse((String)v));
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid ui_locales_supported field: " + e.getMessage(), e);
                }
            }
        }
        if (jsonObject.containsKey((Object)"service_documentation")) {
            op.serviceDocsURI = JSONObjectUtils.getURI(jsonObject, "service_documentation");
        }
        if (jsonObject.containsKey((Object)"op_policy_uri")) {
            op.policyURI = JSONObjectUtils.getURI(jsonObject, "op_policy_uri");
        }
        if (jsonObject.containsKey((Object)"op_tos_uri")) {
            op.tosURI = JSONObjectUtils.getURI(jsonObject, "op_tos_uri");
        }
        if (jsonObject.containsKey((Object)"claims_parameter_supported")) {
            op.claimsParamSupported = JSONObjectUtils.getBoolean(jsonObject, "claims_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"request_parameter_supported")) {
            op.requestParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"request_uri_parameter_supported")) {
            op.requestURIParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_uri_parameter_supported");
        }
        if (jsonObject.containsKey((Object)"require_request_uri_registration")) {
            op.requireRequestURIReg = JSONObjectUtils.getBoolean(jsonObject, "require_request_uri_registration");
        }
        JSONObject customParams = new JSONObject((Map)jsonObject);
        customParams.keySet().removeAll(REGISTERED_PARAMETER_NAMES);
        for (Map.Entry customEntry : customParams.entrySet()) {
            op.setCustomParameter((String)customEntry.getKey(), customEntry.getValue());
        }
        return op;
    }

    public static OIDCProviderMetadata parse(String s) throws ParseException {
        return OIDCProviderMetadata.parse(JSONObjectUtils.parse(s));
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("issuer");
        p.add("authorization_endpoint");
        p.add("token_endpoint");
        p.add("userinfo_endpoint");
        p.add("registration_endpoint");
        p.add("check_session_iframe");
        p.add("end_session_endpoint");
        p.add("jwks_uri");
        p.add("scopes_supported");
        p.add("response_types_supported");
        p.add("response_modes_supported");
        p.add("grant_types_supported");
        p.add("acr_values_supported");
        p.add("subject_types_supported");
        p.add("token_endpoint_auth_methods_supported");
        p.add("token_endpoint_auth_signing_alg_values_supported");
        p.add("request_object_signing_alg_values_supported");
        p.add("request_object_encryption_alg_values_supported");
        p.add("request_object_encryption_enc_values_supported");
        p.add("id_token_signing_alg_values_supported");
        p.add("id_token_encryption_alg_values_supported");
        p.add("id_token_encryption_enc_values_supported");
        p.add("userinfo_signing_alg_values_supported");
        p.add("userinfo_encryption_alg_values_supported");
        p.add("userinfo_encryption_enc_values_supported");
        p.add("display_values_supported");
        p.add("claim_types_supported");
        p.add("claims_supported");
        p.add("claims_locales_supported");
        p.add("ui_locales_supported");
        p.add("service_documentation");
        p.add("op_policy_uri");
        p.add("op_tos_uri");
        p.add("claims_parameter_supported");
        p.add("request_parameter_supported");
        p.add("request_uri_parameter_supported");
        p.add("require_request_uri_registration");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

