/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class ClientAuthentication {
    private final ClientAuthenticationMethod method;
    private final ClientID clientID;

    protected ClientAuthentication(ClientAuthenticationMethod method, ClientID clientID) {
        if (method == null) {
            throw new IllegalArgumentException("The client authentication method must not be null");
        }
        this.method = method;
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.clientID = clientID;
    }

    public ClientAuthenticationMethod getMethod() {
        return this.method;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public static ClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        if (httpRequest.getAuthorization() != null && httpRequest.getAuthorization().startsWith("Basic")) {
            return ClientSecretBasic.parse(httpRequest);
        }
        if (httpRequest.getMethod() != HTTPRequest.Method.POST && !httpRequest.getContentType().match(CommonContentTypes.APPLICATION_URLENCODED)) {
            return null;
        }
        String query = httpRequest.getQuery();
        if (query == null) {
            return null;
        }
        Map<String, String> params = URLUtils.parseParameters(query);
        if (StringUtils.isNotBlank((CharSequence)params.get("client_id")) && StringUtils.isNotBlank((CharSequence)params.get("client_secret"))) {
            return ClientSecretPost.parse(httpRequest);
        }
        if (StringUtils.isNotBlank((CharSequence)params.get("client_assertion")) && StringUtils.isNotBlank((CharSequence)params.get("client_assertion_type"))) {
            return JWTAuthentication.parse(httpRequest);
        }
        return null;
    }

    public abstract void applyTo(HTTPRequest var1);
}

