/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth.verifier;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.oauth2.sdk.id.Audience;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
class JWTAuthenticationClaimsSetVerifier
extends DefaultJWTClaimsVerifier {
    private static BadJWTException INVALID_CLAIM_EXCEPTION = new BadJWTException("Missing or invalid JWT claim");
    private final Set<Audience> expectedAudience;

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> expectedAudience) {
        if (expectedAudience == null || expectedAudience.isEmpty()) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = expectedAudience;
    }

    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        super.verify(claimsSet);
        if (claimsSet.getExpirationTime() == null) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        if (claimsSet.getAudience() == null || claimsSet.getAudience().isEmpty()) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        if (claimsSet.getAudience().size() > 1) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        Audience aud = new Audience((String)claimsSet.getAudience().get(0));
        if (!this.expectedAudience.contains(aud)) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        if (claimsSet.getIssuer() == null || claimsSet.getSubject() == null) {
            throw INVALID_CLAIM_EXCEPTION;
        }
        if (!claimsSet.getIssuer().equals(claimsSet.getSubject())) {
            throw INVALID_CLAIM_EXCEPTION;
        }
    }
}

