/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AbstractOptionallyAuthenticatedRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class TokenRevocationRequest
extends AbstractOptionallyAuthenticatedRequest {
    private final Token token;

    public TokenRevocationRequest(URI uri, ClientAuthentication clientAuth, Token token) {
        super(uri, clientAuth);
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL url;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            url = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", this.token.getValue());
        if (this.token instanceof AccessToken) {
            params.put("token_type_hint", "access_token");
        } else if (this.token instanceof RefreshToken) {
            params.put("token_type_hint", "refresh_token");
        }
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        return httpRequest;
    }

    public static TokenRevocationRequest parse(HTTPRequest httpRequest) throws ParseException {
        URI uri;
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, String> params = httpRequest.getQueryParameters();
        final String tokenValue = params.get("token");
        if (tokenValue == null || tokenValue.isEmpty()) {
            throw new ParseException("Missing required token parameter");
        }
        Token token = null;
        String tokenTypeHint = params.get("token_type_hint");
        if (tokenTypeHint == null) {
            token = new Token(){

                @Override
                public String getValue() {
                    return tokenValue;
                }

                @Override
                public Set<String> getParameterNames() {
                    return Collections.emptySet();
                }

                @Override
                public JSONObject toJSONObject() {
                    return new JSONObject();
                }

                @Override
                public boolean equals(Object other) {
                    return other instanceof Token && other.toString().equals(tokenValue);
                }
            };
        } else if (tokenTypeHint.equals("access_token")) {
            token = new TypelessAccessToken(tokenValue);
        } else if (tokenTypeHint.equals("refresh_token")) {
            token = new RefreshToken(tokenValue);
        }
        ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
        try {
            uri = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        return new TokenRevocationRequest(uri, clientAuth, token);
    }
}

