/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.oauth2.sdk.http.AbstractRestrictedResourceRetriever;
import com.nimbusds.oauth2.sdk.http.Resource;
import com.nimbusds.oauth2.sdk.http.RestrictedResourceRetriever;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.io.input.BoundedInputStream;

@ThreadSafe
@Deprecated
public class DefaultResourceRetriever
extends AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    private final String lineSeparator = System.getProperty("line.separator");

    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout) {
        this(connectTimeout, readTimeout, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit) {
        super(connectTimeout, readTimeout, sizeLimit);
    }

    @Override
    public Resource retrieveResource(URL url) throws IOException {
        String line;
        HttpURLConnection con;
        try {
            con = (HttpURLConnection)url.openConnection();
        }
        catch (ClassCastException e) {
            throw new IOException("Couldn't open HTTP(S) connection: " + e.getMessage(), e);
        }
        con.setConnectTimeout(this.getConnectTimeout());
        con.setReadTimeout(this.getReadTimeout());
        StringBuilder sb = new StringBuilder();
        InputStream inputStream = con.getInputStream();
        if (this.getSizeLimit() > 0) {
            inputStream = new BoundedInputStream(inputStream, (long)this.getSizeLimit());
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = input.readLine()) != null) {
            sb.append(line);
            sb.append(this.lineSeparator);
        }
        input.close();
        int statusCode = con.getResponseCode();
        String statusMessage = con.getResponseMessage();
        if (statusCode > 299 || statusCode < 200) {
            throw new IOException("HTTP " + statusCode + ": " + statusMessage);
        }
        ContentType contentType = null;
        if (con.getContentType() != null) {
            try {
                contentType = new ContentType(con.getContentType());
            }
            catch (ParseException e) {
                throw new IOException("Couldn't parse Content-Type header: " + e.getMessage(), e);
            }
        }
        return new Resource(sb.toString(), contentType);
    }
}

