/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class TLSClientAuthentication
extends ClientAuthentication {
    private final SSLSocketFactory sslSocketFactory;
    private final X509Certificate x509Certificate;

    public TLSClientAuthentication(ClientID clientID, SSLSocketFactory sslSocketFactory) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID);
        this.sslSocketFactory = sslSocketFactory;
        this.x509Certificate = null;
    }

    public TLSClientAuthentication(ClientID clientID, X509Certificate x509Certificate) {
        super(ClientAuthenticationMethod.TLS_CLIENT_AUTH, clientID);
        this.sslSocketFactory = null;
        if (x509Certificate == null) {
            throw new IllegalArgumentException("The client X.509 certificate must not be null");
        }
        this.x509Certificate = x509Certificate;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public X509Certificate getClientX509Certificate() {
        return this.x509Certificate;
    }

    @Override
    public void applyTo(HTTPRequest httpRequest) {
        httpRequest.setSSLSocketFactory(this.sslSocketFactory);
    }

    public static TLSClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing HTTP POST request entity body");
        }
        Map<String, String> params = URLUtils.parseParameters(query);
        String clientIDString = params.get("client_id");
        if (StringUtils.isBlank((CharSequence)clientIDString)) {
            throw new ParseException("Missing client_id parameter");
        }
        X509Certificate cert = httpRequest.getClientX509Certificate();
        if (cert == null) {
            throw new ParseException("Missing client X.509 certificate");
        }
        return new TLSClientAuthentication(new ClientID(clientIDString), cert);
    }

    public static /* bridge */ /* synthetic */ ClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        return TLSClientAuthentication.parse(hTTPRequest);
    }
}

