/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class OIDCTokenResponse
extends AccessTokenResponse {
    private final OIDCTokens tokens;

    public OIDCTokenResponse(OIDCTokens tokens) {
        this(tokens, null);
    }

    public OIDCTokenResponse(OIDCTokens tokens, Map<String, Object> customParams) {
        super(tokens, customParams);
        this.tokens = tokens;
    }

    public OIDCTokens getOIDCTokens() {
        return this.tokens;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"id_token", (Object)this.getOIDCTokens().getIDTokenString());
        return o;
    }

    public static OIDCTokenResponse parse(JSONObject jsonObject) throws ParseException {
        OIDCTokens tokens = OIDCTokens.parse(jsonObject);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.putAll((Map<String, Object>)jsonObject);
        for (String tokenParam : tokens.getParameterNames()) {
            customParams.remove(tokenParam);
        }
        if (customParams.isEmpty()) {
            return new OIDCTokenResponse(tokens);
        }
        return new OIDCTokenResponse(tokens, customParams);
    }

    public static OIDCTokenResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return OIDCTokenResponse.parse(jsonObject);
    }

    public static /* bridge */ /* synthetic */ AccessTokenResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return OIDCTokenResponse.parse(hTTPResponse);
    }

    public static /* bridge */ /* synthetic */ AccessTokenResponse parse(JSONObject jSONObject) throws ParseException {
        return OIDCTokenResponse.parse(jSONObject);
    }
}

