/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.tuple.ImmutablePair;

@Immutable
public final class X509CertificateConfirmation {
    private final Base64URL x5tS256;

    public X509CertificateConfirmation(Base64URL x5tS256) {
        if (x5tS256 == null) {
            throw new IllegalArgumentException("The X.509 certificate thumbprint must not be null");
        }
        this.x5tS256 = x5tS256;
    }

    public Base64URL getValue() {
        return this.x5tS256;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        Map.Entry<String, JSONObject> cnfClaim = this.toJWTClaim();
        jsonObject.put((Object)cnfClaim.getKey(), (Object)cnfClaim.getValue());
        return jsonObject;
    }

    public Map.Entry<String, JSONObject> toJWTClaim() {
        JSONObject cnf = new JSONObject();
        cnf.put((Object)"x5t#S256", (Object)this.x5tS256.toString());
        return new ImmutablePair((Object)"cnf", (Object)cnf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509CertificateConfirmation)) {
            return false;
        }
        X509CertificateConfirmation that = (X509CertificateConfirmation)o;
        return this.x5tS256 != null ? this.x5tS256.equals((Object)that.x5tS256) : that.x5tS256 == null;
    }

    public int hashCode() {
        return this.x5tS256 != null ? this.x5tS256.hashCode() : 0;
    }

    public static X509CertificateConfirmation parse(JWTClaimsSet jwtClaimsSet) {
        String x5tString;
        block5: {
            JSONObject cnf;
            block4: {
                try {
                    cnf = jwtClaimsSet.getJSONObjectClaim("cnf");
                    if (cnf != null) break block4;
                    return null;
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
            x5tString = JSONObjectUtils.getString((JSONObject)cnf, (String)"x5t#S256");
            if (x5tString != null) break block5;
            return null;
        }
        return new X509CertificateConfirmation(new Base64URL(x5tString));
    }
}

