/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.X509CertUtils;
import com.nimbusds.jwt.JWTClaimsSet;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.tuple.ImmutablePair;

@Immutable
public final class X509CertificateConfirmation {
    private final Base64URL x5tS256;

    public X509CertificateConfirmation(Base64URL x5tS256) {
        if (x5tS256 == null) {
            throw new IllegalArgumentException("The X.509 certificate thumbprint must not be null");
        }
        this.x5tS256 = x5tS256;
    }

    public Base64URL getValue() {
        return this.x5tS256;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        Map.Entry<String, JSONObject> cnfClaim = this.toJWTClaim();
        jsonObject.put((Object)cnfClaim.getKey(), (Object)cnfClaim.getValue());
        return jsonObject;
    }

    public Map.Entry<String, JSONObject> toJWTClaim() {
        JSONObject cnf = new JSONObject();
        cnf.put((Object)"x5t#S256", (Object)this.x5tS256.toString());
        return new ImmutablePair((Object)"cnf", (Object)cnf);
    }

    public JWTClaimsSet applyTo(JWTClaimsSet jwtClaimsSet) {
        Map.Entry<String, JSONObject> cnfClaim = this.toJWTClaim();
        return new JWTClaimsSet.Builder(jwtClaimsSet).claim(cnfClaim.getKey(), (Object)cnfClaim.getValue()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509CertificateConfirmation)) {
            return false;
        }
        X509CertificateConfirmation that = (X509CertificateConfirmation)o;
        return this.x5tS256 != null ? this.x5tS256.equals((Object)that.x5tS256) : that.x5tS256 == null;
    }

    public int hashCode() {
        return this.x5tS256 != null ? this.x5tS256.hashCode() : 0;
    }

    public static X509CertificateConfirmation parse(JWTClaimsSet jwtClaimsSet) {
        JSONObject cnf;
        try {
            cnf = jwtClaimsSet.getJSONObjectClaim("cnf");
        }
        catch (ParseException parseException) {
            return null;
        }
        return X509CertificateConfirmation.parseFromConfirmationJSONObject(cnf);
    }

    public static X509CertificateConfirmation parse(JSONObject jsonObject) {
        JSONObject cnf;
        try {
            cnf = JSONObjectUtils.getJSONObject((JSONObject)jsonObject, (String)"cnf");
        }
        catch (ParseException parseException) {
            return null;
        }
        return X509CertificateConfirmation.parseFromConfirmationJSONObject(cnf);
    }

    public static X509CertificateConfirmation parseFromConfirmationJSONObject(JSONObject cnf) {
        String x5tString;
        block4: {
            if (cnf == null) {
                return null;
            }
            try {
                x5tString = JSONObjectUtils.getString((JSONObject)cnf, (String)"x5t#S256");
                if (x5tString != null) break block4;
                return null;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return new X509CertificateConfirmation(new Base64URL(x5tString));
    }

    public static X509CertificateConfirmation of(X509Certificate x509Cert) {
        return new X509CertificateConfirmation(X509CertUtils.computeSHA256Thumbprint((X509Certificate)x509Cert));
    }
}

