/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.as;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.OrderedJSONObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public class AuthorizationServerMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final Issuer issuer;
    private URI authzEndpoint;
    private URI tokenEndpoint;
    private URI regEndpoint;
    private URI introspectionEndpoint;
    private URI revocationEndpoint;
    private URI jwkSetURI;
    private Scope scope;
    private List<ResponseType> rts;
    private List<ResponseMode> rms;
    private List<GrantType> gts;
    private List<CodeChallengeMethod> codeChallengeMethods;
    private List<ClientAuthenticationMethod> tokenEndpointAuthMethods;
    private List<JWSAlgorithm> tokenEndpointJWSAlgs;
    private List<ClientAuthenticationMethod> introspectionEndpointAuthMethods;
    private List<JWSAlgorithm> introspectionEndpointJWSAlgs;
    private List<ClientAuthenticationMethod> revocationEndpointAuthMethods;
    private List<JWSAlgorithm> revocationEndpointJWSAlgs;
    private List<JWSAlgorithm> requestObjectJWSAlgs;
    private List<JWEAlgorithm> requestObjectJWEAlgs;
    private List<EncryptionMethod> requestObjectJWEEncs;
    private boolean requestParamSupported = false;
    private boolean requestURIParamSupported = true;
    private boolean requireRequestURIReg = false;
    private List<LangTag> uiLocales;
    private URI serviceDocsURI;
    private URI policyURI;
    private URI tosURI;
    private boolean mutualTLSSenderConstrainedAccessTokens = false;
    private final JSONObject customParameters = new JSONObject();

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("issuer");
        p.add("authorization_endpoint");
        p.add("token_endpoint");
        p.add("registration_endpoint");
        p.add("jwks_uri");
        p.add("scopes_supported");
        p.add("response_types_supported");
        p.add("response_modes_supported");
        p.add("grant_types_supported");
        p.add("code_challenge_methods_supported");
        p.add("token_endpoint_auth_methods_supported");
        p.add("token_endpoint_auth_signing_alg_values_supported");
        p.add("request_object_signing_alg_values_supported");
        p.add("request_object_encryption_alg_values_supported");
        p.add("request_object_encryption_enc_values_supported");
        p.add("ui_locales_supported");
        p.add("service_documentation");
        p.add("op_policy_uri");
        p.add("op_tos_uri");
        p.add("introspection_endpoint");
        p.add("introspection_endpoint_auth_methods_supported");
        p.add("introspection_endpoint_auth_signing_alg_values_supported");
        p.add("revocation_endpoint");
        p.add("revocation_endpoint_auth_methods_supported");
        p.add("revocation_endpoint_auth_signing_alg_values_supported");
        p.add("mutual_tls_sender_constrained_access_tokens");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public AuthorizationServerMetadata(Issuer issuer) {
        URI uri;
        try {
            uri = new URI(issuer.getValue());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The issuer identifier must be a URI: " + e.getMessage(), e);
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a query component");
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException("The issuer URI must be without a fragment component");
        }
        this.issuer = issuer;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public URI getAuthorizationEndpointURI() {
        return this.authzEndpoint;
    }

    public void setAuthorizationEndpointURI(URI authzEndpoint) {
        this.authzEndpoint = authzEndpoint;
    }

    public URI getTokenEndpointURI() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpointURI(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public URI getRegistrationEndpointURI() {
        return this.regEndpoint;
    }

    public void setRegistrationEndpointURI(URI regEndpoint) {
        this.regEndpoint = regEndpoint;
    }

    public URI getIntrospectionEndpointURI() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpointURI(URI introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public URI getRevocationEndpointURI() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpointURI(URI revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public void setJWKSetURI(URI jwkSetURI) {
        this.jwkSetURI = jwkSetURI;
    }

    public Scope getScopes() {
        return this.scope;
    }

    public void setScopes(Scope scope) {
        this.scope = scope;
    }

    public List<ResponseType> getResponseTypes() {
        return this.rts;
    }

    public void setResponseTypes(List<ResponseType> rts) {
        this.rts = rts;
    }

    public List<ResponseMode> getResponseModes() {
        return this.rms;
    }

    public void setResponseModes(List<ResponseMode> rms) {
        this.rms = rms;
    }

    public List<GrantType> getGrantTypes() {
        return this.gts;
    }

    public void setGrantTypes(List<GrantType> gts) {
        this.gts = gts;
    }

    public List<CodeChallengeMethod> getCodeChallengeMethods() {
        return this.codeChallengeMethods;
    }

    public void setCodeChallengeMethods(List<CodeChallengeMethod> codeChallengeMethods) {
        this.codeChallengeMethods = codeChallengeMethods;
    }

    public List<ClientAuthenticationMethod> getTokenEndpointAuthMethods() {
        return this.tokenEndpointAuthMethods;
    }

    public void setTokenEndpointAuthMethods(List<ClientAuthenticationMethod> authMethods) {
        this.tokenEndpointAuthMethods = authMethods;
    }

    public List<JWSAlgorithm> getTokenEndpointJWSAlgs() {
        return this.tokenEndpointJWSAlgs;
    }

    public void setTokenEndpointJWSAlgs(List<JWSAlgorithm> jwsAlgs) {
        if (jwsAlgs != null && jwsAlgs.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The \"none\" algorithm is not accepted");
        }
        this.tokenEndpointJWSAlgs = jwsAlgs;
    }

    public List<ClientAuthenticationMethod> getIntrospectionEndpointAuthMethods() {
        return this.introspectionEndpointAuthMethods;
    }

    public void setIntrospectionEndpointAuthMethods(List<ClientAuthenticationMethod> authMethods) {
        this.introspectionEndpointAuthMethods = authMethods;
    }

    public List<JWSAlgorithm> getIntrospectionEndpointJWSAlgs() {
        return this.introspectionEndpointJWSAlgs;
    }

    public void setIntrospectionEndpointJWSAlgs(List<JWSAlgorithm> jwsAlgs) {
        if (jwsAlgs != null && jwsAlgs.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The \"none\" algorithm is not accepted");
        }
        this.introspectionEndpointJWSAlgs = jwsAlgs;
    }

    public List<ClientAuthenticationMethod> getRevocationEndpointAuthMethods() {
        return this.revocationEndpointAuthMethods;
    }

    public void setRevocationEndpointAuthMethods(List<ClientAuthenticationMethod> authMethods) {
        this.revocationEndpointAuthMethods = authMethods;
    }

    public List<JWSAlgorithm> getRevocationEndpointJWSAlgs() {
        return this.revocationEndpointJWSAlgs;
    }

    public void setRevocationEndpointJWSAlgs(List<JWSAlgorithm> jwsAlgs) {
        if (jwsAlgs != null && jwsAlgs.contains(Algorithm.NONE)) {
            throw new IllegalArgumentException("The \"none\" algorithm is not accepted");
        }
        this.revocationEndpointJWSAlgs = jwsAlgs;
    }

    public List<JWSAlgorithm> getRequestObjectJWSAlgs() {
        return this.requestObjectJWSAlgs;
    }

    public void setRequestObjectJWSAlgs(List<JWSAlgorithm> requestObjectJWSAlgs) {
        this.requestObjectJWSAlgs = requestObjectJWSAlgs;
    }

    public List<JWEAlgorithm> getRequestObjectJWEAlgs() {
        return this.requestObjectJWEAlgs;
    }

    public void setRequestObjectJWEAlgs(List<JWEAlgorithm> requestObjectJWEAlgs) {
        this.requestObjectJWEAlgs = requestObjectJWEAlgs;
    }

    public List<EncryptionMethod> getRequestObjectJWEEncs() {
        return this.requestObjectJWEEncs;
    }

    public void setRequestObjectJWEEncs(List<EncryptionMethod> requestObjectJWEEncs) {
        this.requestObjectJWEEncs = requestObjectJWEEncs;
    }

    public boolean supportsRequestParam() {
        return this.requestParamSupported;
    }

    public void setSupportsRequestParam(boolean requestParamSupported) {
        this.requestParamSupported = requestParamSupported;
    }

    public boolean supportsRequestURIParam() {
        return this.requestURIParamSupported;
    }

    public void setSupportsRequestURIParam(boolean requestURIParamSupported) {
        this.requestURIParamSupported = requestURIParamSupported;
    }

    public boolean requiresRequestURIRegistration() {
        return this.requireRequestURIReg;
    }

    public void setRequiresRequestURIRegistration(boolean requireRequestURIReg) {
        this.requireRequestURIReg = requireRequestURIReg;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public void setUILocales(List<LangTag> uiLocales) {
        this.uiLocales = uiLocales;
    }

    public URI getServiceDocsURI() {
        return this.serviceDocsURI;
    }

    public void setServiceDocsURI(URI serviceDocsURI) {
        this.serviceDocsURI = serviceDocsURI;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI policyURI) {
        this.policyURI = policyURI;
    }

    public URI getTermsOfServiceURI() {
        return this.tosURI;
    }

    public void setTermsOfServiceURI(URI tosURI) {
        this.tosURI = tosURI;
    }

    public boolean supportsMutualTLSSenderConstrainedAccessTokens() {
        return this.mutualTLSSenderConstrainedAccessTokens;
    }

    public void setSupportsMutualTLSSenderConstrainedAccessTokens(boolean mutualTLSSenderConstrainedAccessTokens) {
        this.mutualTLSSenderConstrainedAccessTokens = mutualTLSSenderConstrainedAccessTokens;
    }

    public Object getCustomParameter(String name) {
        return this.customParameters.get((Object)name);
    }

    public URI getCustomURIParameter(String name) {
        try {
            return JSONObjectUtils.getURI(this.customParameters, name);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setCustomParameter(String name, Object value) {
        if (REGISTERED_PARAMETER_NAMES.contains(name)) {
            throw new IllegalArgumentException("The " + name + " parameter is registered");
        }
        this.customParameters.put((Object)name, value);
    }

    public JSONObject getCustomParameters() {
        return this.customParameters;
    }

    public void applyDefaults() {
        if (this.rms == null) {
            this.rms = new ArrayList<ResponseMode>(2);
            this.rms.add(ResponseMode.QUERY);
            this.rms.add(ResponseMode.FRAGMENT);
        }
        if (this.gts == null) {
            this.gts = new ArrayList<GrantType>(2);
            this.gts.add(GrantType.AUTHORIZATION_CODE);
            this.gts.add(GrantType.IMPLICIT);
        }
    }

    public JSONObject toJSONObject() {
        ArrayList<String> stringList;
        OrderedJSONObject o = new OrderedJSONObject();
        o.put("issuer", this.issuer.getValue());
        if (this.jwkSetURI != null) {
            o.put("jwks_uri", this.jwkSetURI.toString());
        }
        if (this.authzEndpoint != null) {
            o.put("authorization_endpoint", this.authzEndpoint.toString());
        }
        if (this.tokenEndpoint != null) {
            o.put("token_endpoint", this.tokenEndpoint.toString());
        }
        if (this.regEndpoint != null) {
            o.put("registration_endpoint", this.regEndpoint.toString());
        }
        if (this.introspectionEndpoint != null) {
            o.put("introspection_endpoint", this.introspectionEndpoint.toString());
        }
        if (this.revocationEndpoint != null) {
            o.put("revocation_endpoint", this.revocationEndpoint.toString());
        }
        if (this.scope != null) {
            o.put("scopes_supported", this.scope.toStringList());
        }
        if (this.rts != null) {
            stringList = new ArrayList<String>(this.rts.size());
            for (ResponseType responseType : this.rts) {
                stringList.add(responseType.toString());
            }
            o.put("response_types_supported", stringList);
        }
        if (this.rms != null) {
            stringList = new ArrayList(this.rms.size());
            for (ResponseMode responseMode : this.rms) {
                stringList.add(responseMode.getValue());
            }
            o.put("response_modes_supported", stringList);
        }
        if (this.gts != null) {
            stringList = new ArrayList(this.gts.size());
            for (GrantType grantType : this.gts) {
                stringList.add(grantType.toString());
            }
            o.put("grant_types_supported", stringList);
        }
        if (this.codeChallengeMethods != null) {
            stringList = new ArrayList(this.codeChallengeMethods.size());
            for (CodeChallengeMethod codeChallengeMethod : this.codeChallengeMethods) {
                stringList.add(codeChallengeMethod.getValue());
            }
            o.put("code_challenge_methods_supported", stringList);
        }
        if (this.tokenEndpointAuthMethods != null) {
            stringList = new ArrayList(this.tokenEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.tokenEndpointAuthMethods) {
                stringList.add(clientAuthenticationMethod.getValue());
            }
            o.put("token_endpoint_auth_methods_supported", stringList);
        }
        if (this.tokenEndpointJWSAlgs != null) {
            stringList = new ArrayList(this.tokenEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.tokenEndpointJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("token_endpoint_auth_signing_alg_values_supported", stringList);
        }
        if (this.introspectionEndpointAuthMethods != null) {
            stringList = new ArrayList(this.introspectionEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.introspectionEndpointAuthMethods) {
                stringList.add(clientAuthenticationMethod.getValue());
            }
            o.put("introspection_endpoint_auth_methods_supported", stringList);
        }
        if (this.introspectionEndpointJWSAlgs != null) {
            stringList = new ArrayList(this.introspectionEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.introspectionEndpointJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("introspection_endpoint_auth_signing_alg_values_supported", stringList);
        }
        if (this.revocationEndpointAuthMethods != null) {
            stringList = new ArrayList(this.revocationEndpointAuthMethods.size());
            for (ClientAuthenticationMethod clientAuthenticationMethod : this.revocationEndpointAuthMethods) {
                stringList.add(clientAuthenticationMethod.getValue());
            }
            o.put("revocation_endpoint_auth_methods_supported", stringList);
        }
        if (this.revocationEndpointJWSAlgs != null) {
            stringList = new ArrayList(this.revocationEndpointJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.revocationEndpointJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("revocation_endpoint_auth_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWSAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWSAlgs.size());
            for (JWSAlgorithm jWSAlgorithm : this.requestObjectJWSAlgs) {
                stringList.add(jWSAlgorithm.getName());
            }
            o.put("request_object_signing_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEAlgs != null) {
            stringList = new ArrayList(this.requestObjectJWEAlgs.size());
            for (JWEAlgorithm jWEAlgorithm : this.requestObjectJWEAlgs) {
                stringList.add(jWEAlgorithm.getName());
            }
            o.put("request_object_encryption_alg_values_supported", stringList);
        }
        if (this.requestObjectJWEEncs != null) {
            stringList = new ArrayList(this.requestObjectJWEEncs.size());
            for (EncryptionMethod encryptionMethod : this.requestObjectJWEEncs) {
                stringList.add(encryptionMethod.getName());
            }
            o.put("request_object_encryption_enc_values_supported", stringList);
        }
        if (this.uiLocales != null) {
            stringList = new ArrayList(this.uiLocales.size());
            for (LangTag langTag : this.uiLocales) {
                stringList.add(langTag.toString());
            }
            o.put("ui_locales_supported", stringList);
        }
        if (this.serviceDocsURI != null) {
            o.put("service_documentation", this.serviceDocsURI.toString());
        }
        if (this.policyURI != null) {
            o.put("op_policy_uri", this.policyURI.toString());
        }
        if (this.tosURI != null) {
            o.put("op_tos_uri", this.tosURI.toString());
        }
        o.put("request_parameter_supported", this.requestParamSupported);
        o.put("request_uri_parameter_supported", this.requestURIParamSupported);
        o.put("require_request_uri_registration", this.requireRequestURIReg);
        o.put("mutual_tls_sender_constrained_access_tokens", this.mutualTLSSenderConstrainedAccessTokens);
        o.putAll((Map)this.customParameters);
        return o;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static AuthorizationServerMetadata parse(JSONObject jsonObject) throws ParseException {
        String v;
        int n;
        int n2;
        String[] stringArray;
        AuthorizationServerMetadata as;
        Issuer issuer = new Issuer(JSONObjectUtils.getURI(jsonObject, "issuer").toString());
        try {
            as = new AuthorizationServerMetadata(issuer);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (jsonObject.get((Object)"authorization_endpoint") != null) {
            as.authzEndpoint = JSONObjectUtils.getURI(jsonObject, "authorization_endpoint");
        }
        if (jsonObject.get((Object)"token_endpoint") != null) {
            as.tokenEndpoint = JSONObjectUtils.getURI(jsonObject, "token_endpoint");
        }
        if (jsonObject.get((Object)"registration_endpoint") != null) {
            as.regEndpoint = JSONObjectUtils.getURI(jsonObject, "registration_endpoint");
        }
        if (jsonObject.get((Object)"jwks_uri") != null) {
            as.jwkSetURI = JSONObjectUtils.getURI(jsonObject, "jwks_uri");
        }
        if (jsonObject.get((Object)"introspection_endpoint") != null) {
            as.introspectionEndpoint = JSONObjectUtils.getURI(jsonObject, "introspection_endpoint");
        }
        if (jsonObject.get((Object)"revocation_endpoint") != null) {
            as.revocationEndpoint = JSONObjectUtils.getURI(jsonObject, "revocation_endpoint");
        }
        if (jsonObject.get((Object)"scopes_supported") != null) {
            as.scope = new Scope();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "scopes_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.scope.add(new Scope.Value(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"response_types_supported") != null) {
            as.rts = new ArrayList<ResponseType>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "response_types_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.rts.add(ResponseType.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"response_modes_supported") != null) {
            as.rms = new ArrayList<ResponseMode>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "response_modes_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.rms.add(new ResponseMode(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"grant_types_supported") != null) {
            as.gts = new ArrayList<GrantType>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "grant_types_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.gts.add(GrantType.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"code_challenge_methods_supported") != null) {
            as.codeChallengeMethods = new ArrayList<CodeChallengeMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "code_challenge_methods_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.codeChallengeMethods.add(CodeChallengeMethod.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"token_endpoint_auth_methods_supported") != null) {
            as.tokenEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_methods_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.tokenEndpointAuthMethods.add(ClientAuthenticationMethod.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"token_endpoint_auth_signing_alg_values_supported") != null) {
            as.tokenEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "token_endpoint_auth_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null && v.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (v != null) {
                    as.tokenEndpointJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"introspection_endpoint_auth_methods_supported") != null) {
            as.introspectionEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "introspection_endpoint_auth_methods_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.introspectionEndpointAuthMethods.add(ClientAuthenticationMethod.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"introspection_endpoint_auth_signing_alg_values_supported") != null) {
            as.introspectionEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "introspection_endpoint_auth_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null && v.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (v != null) {
                    as.introspectionEndpointJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"revocation_endpoint_auth_methods_supported") != null) {
            as.revocationEndpointAuthMethods = new ArrayList<ClientAuthenticationMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "revocation_endpoint_auth_methods_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.revocationEndpointAuthMethods.add(ClientAuthenticationMethod.parse(v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"revocation_endpoint_auth_signing_alg_values_supported") != null) {
            as.revocationEndpointJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "revocation_endpoint_auth_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null && v.equals(Algorithm.NONE.getName())) {
                    throw new ParseException("The none algorithm is not accepted");
                }
                if (v != null) {
                    as.revocationEndpointJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"request_object_signing_alg_values_supported") != null) {
            as.requestObjectJWSAlgs = new ArrayList<JWSAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_signing_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.requestObjectJWSAlgs.add(JWSAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"request_object_encryption_alg_values_supported") != null) {
            as.requestObjectJWEAlgs = new ArrayList<JWEAlgorithm>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_alg_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.requestObjectJWEAlgs.add(JWEAlgorithm.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"request_object_encryption_enc_values_supported") != null) {
            as.requestObjectJWEEncs = new ArrayList<EncryptionMethod>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "request_object_encryption_enc_values_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    as.requestObjectJWEEncs.add(EncryptionMethod.parse((String)v));
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"ui_locales_supported") != null) {
            as.uiLocales = new ArrayList<LangTag>();
            stringArray = JSONObjectUtils.getStringArray(jsonObject, "ui_locales_supported");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                if (v != null) {
                    try {
                        as.uiLocales.add(LangTag.parse((String)v));
                    }
                    catch (LangTagException e) {
                        throw new ParseException("Invalid ui_locales_supported field: " + e.getMessage(), e);
                    }
                }
                ++n;
            }
        }
        if (jsonObject.get((Object)"service_documentation") != null) {
            as.serviceDocsURI = JSONObjectUtils.getURI(jsonObject, "service_documentation");
        }
        if (jsonObject.get((Object)"op_policy_uri") != null) {
            as.policyURI = JSONObjectUtils.getURI(jsonObject, "op_policy_uri");
        }
        if (jsonObject.get((Object)"op_tos_uri") != null) {
            as.tosURI = JSONObjectUtils.getURI(jsonObject, "op_tos_uri");
        }
        if (jsonObject.get((Object)"request_parameter_supported") != null) {
            as.requestParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_parameter_supported");
        }
        if (jsonObject.get((Object)"request_uri_parameter_supported") != null) {
            as.requestURIParamSupported = JSONObjectUtils.getBoolean(jsonObject, "request_uri_parameter_supported");
        }
        if (jsonObject.get((Object)"require_request_uri_registration") != null) {
            as.requireRequestURIReg = JSONObjectUtils.getBoolean(jsonObject, "require_request_uri_registration");
        }
        if (jsonObject.get((Object)"mutual_tls_sender_constrained_access_tokens") != null) {
            as.mutualTLSSenderConstrainedAccessTokens = JSONObjectUtils.getBoolean(jsonObject, "mutual_tls_sender_constrained_access_tokens");
        }
        JSONObject customParams = new JSONObject((Map)jsonObject);
        customParams.keySet().removeAll(REGISTERED_PARAMETER_NAMES);
        for (Map.Entry customEntry : customParams.entrySet()) {
            as.setCustomParameter((String)customEntry.getKey(), customEntry.getValue());
        }
        return as;
    }

    public static AuthorizationServerMetadata parse(String s) throws ParseException {
        return AuthorizationServerMetadata.parse(JSONObjectUtils.parse(s));
    }

    public static AuthorizationServerMetadata resolve(Issuer issuer) throws GeneralException, IOException {
        return AuthorizationServerMetadata.resolve(issuer, 0, 0);
    }

    public static AuthorizationServerMetadata resolve(Issuer issuer, int connectTimeout, int readTimeout) throws GeneralException, IOException {
        URL configURL;
        try {
            URL issuerURL = new URL(issuer.getValue());
            if (issuerURL.getQuery() != null && !issuerURL.getQuery().trim().isEmpty()) {
                throw new GeneralException("The issuer identifier must not contain a query component");
            }
            configURL = issuerURL.getPath() != null && issuerURL.getPath().endsWith("/") ? new URL(issuerURL + ".well-known/oauth-authorization-server") : new URL(issuerURL + "/.well-known/oauth-authorization-server");
        }
        catch (MalformedURLException e) {
            throw new GeneralException("The issuer identifier doesn't represent a valid URL: " + e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, configURL);
        httpRequest.setConnectTimeout(connectTimeout);
        httpRequest.setReadTimeout(readTimeout);
        HTTPResponse httpResponse = httpRequest.send();
        if (httpResponse.getStatusCode() != 200) {
            throw new IOException("Couldn't download OAuth 2.0 Authorization Server metadata from " + configURL + ": Status code " + httpResponse.getStatusCode());
        }
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        AuthorizationServerMetadata as = AuthorizationServerMetadata.parse(jsonObject);
        if (!issuer.equals(as.issuer)) {
            throw new GeneralException("The returned issuer doesn't match the expected: " + as.getIssuer());
        }
        return as;
    }
}

