/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.util;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class URLUtils {
    public static final String CHARSET = "utf-8";

    public static URL getBaseURL(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String serializeParameters(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getKey() == null) continue;
            String value = entry.getValue() != null ? entry.getValue() : "";
            try {
                String encodedKey = URLEncoder.encode(entry.getKey(), CHARSET);
                String encodedValue = URLEncoder.encode(value, CHARSET);
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(encodedKey);
                sb.append('=');
                sb.append(encodedValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return sb.toString();
    }

    public static String serializeParametersAlt(Map<String, String[]> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            String[] stringArray = entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value == null) {
                    value = "";
                }
                try {
                    String encodedKey = URLEncoder.encode(entry.getKey(), CHARSET);
                    String encodedValue = URLEncoder.encode(value, CHARSET);
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    sb.append(encodedKey);
                    sb.append('=');
                    sb.append(encodedValue);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                ++n2;
            }
        }
        return sb.toString();
    }

    public static Map<String, String> parseParameters(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isBlank(query)) {
            return params;
        }
        try {
            StringTokenizer st = new StringTokenizer(query.trim(), "&");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                String[] pair = param.split("=", 2);
                String key = URLDecoder.decode(pair[0], CHARSET);
                if (params.containsKey(key)) continue;
                String value = "";
                if (pair.length > 1) {
                    value = URLDecoder.decode(pair[1], CHARSET);
                }
                params.put(key, value);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return params;
    }

    private URLUtils() {
    }
}

