/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class UserInfoErrorResponse
extends UserInfoResponse
implements ErrorResponse {
    private final BearerTokenError error;

    public static Set<BearerTokenError> getStandardErrors() {
        HashSet<BearerTokenError> stdErrors = new HashSet<BearerTokenError>();
        stdErrors.add(BearerTokenError.MISSING_TOKEN);
        stdErrors.add(BearerTokenError.INVALID_REQUEST);
        stdErrors.add(BearerTokenError.INVALID_TOKEN);
        stdErrors.add(BearerTokenError.INSUFFICIENT_SCOPE);
        return Collections.unmodifiableSet(stdErrors);
    }

    private UserInfoErrorResponse() {
        this.error = null;
    }

    public UserInfoErrorResponse(BearerTokenError error) {
        if (error == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = error;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = this.error != null && this.error.getHTTPStatusCode() > 0 ? new HTTPResponse(this.error.getHTTPStatusCode()) : new HTTPResponse(400);
        if (this.error != null) {
            httpResponse.setWWWAuthenticate(this.error.toWWWAuthenticateHeader());
        }
        return httpResponse;
    }

    public static UserInfoErrorResponse parse(String wwwAuth) throws ParseException {
        BearerTokenError error = BearerTokenError.parse(wwwAuth);
        return new UserInfoErrorResponse(error);
    }

    public static UserInfoErrorResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCodeNotOK();
        String wwwAuth = httpResponse.getWWWAuthenticate();
        if (StringUtils.isNotBlank((CharSequence)wwwAuth)) {
            return UserInfoErrorResponse.parse(wwwAuth);
        }
        return new UserInfoErrorResponse();
    }
}

