/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientCredentialsGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.CLIENT_CREDENTIALS;

    public ClientCredentialsGrant() {
        super(GRANT_TYPE);
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        return params;
    }

    public static ClientCredentialsGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            String msg = "Missing \"grant_type\" parameter";
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
        if (!GrantType.parse(grantTypeString).equals(GRANT_TYPE)) {
            String msg = "The \"grant_type\" must be " + GRANT_TYPE;
            throw new ParseException(msg, OAuth2Error.UNSUPPORTED_GRANT_TYPE.appendDescription(": " + msg));
        }
        return new ClientCredentialsGrant();
    }
}

