/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

public class ClaimsRequest {
    private final Map<Map.Entry<String, LangTag>, Entry> idTokenClaims = new HashMap<Map.Entry<String, LangTag>, Entry>();
    private final Map<Map.Entry<String, LangTag>, Entry> userInfoClaims = new HashMap<Map.Entry<String, LangTag>, Entry>();

    public void add(ClaimsRequest other) {
        if (other == null) {
            return;
        }
        this.idTokenClaims.putAll(other.idTokenClaims);
        this.userInfoClaims.putAll(other.userInfoClaims);
    }

    public void addIDTokenClaim(String claimName) {
        this.addIDTokenClaim(claimName, ClaimRequirement.VOLUNTARY);
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement) {
        this.addIDTokenClaim(claimName, requirement, null);
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag) {
        this.addIDTokenClaim(claimName, requirement, langTag, (String)null);
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag, String value) {
        this.addIDTokenClaim(new Entry(claimName, requirement, langTag, value));
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag, String value, Map<String, Object> additionalInformation) {
        this.addIDTokenClaim(new Entry(claimName, requirement, langTag, value, null, additionalInformation));
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values) {
        this.addIDTokenClaim(new Entry(claimName, requirement, langTag, values));
    }

    public void addIDTokenClaim(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values, Map<String, Object> additionalInformation) {
        this.addIDTokenClaim(new Entry(claimName, requirement, langTag, null, values, additionalInformation));
    }

    public void addIDTokenClaim(Entry entry) {
        AbstractMap.SimpleImmutableEntry<String, LangTag> key = new AbstractMap.SimpleImmutableEntry<String, LangTag>(entry.getClaimName(), entry.getLangTag());
        this.idTokenClaims.put(key, entry);
    }

    public Collection<Entry> getIDTokenClaims() {
        return Collections.unmodifiableCollection(this.idTokenClaims.values());
    }

    public Set<String> getIDTokenClaimNames(boolean withLangTag) {
        HashSet<String> names = new HashSet<String>();
        for (Entry en : this.idTokenClaims.values()) {
            names.add(en.getClaimName(withLangTag));
        }
        return Collections.unmodifiableSet(names);
    }

    public Entry removeIDTokenClaim(String claimName, LangTag langTag) {
        AbstractMap.SimpleImmutableEntry<String, LangTag> key = new AbstractMap.SimpleImmutableEntry<String, LangTag>(claimName, langTag);
        return this.idTokenClaims.remove(key);
    }

    public Collection<Entry> removeIDTokenClaims(String claimName) {
        LinkedList<Entry> removedClaims = new LinkedList<Entry>();
        Iterator<Map.Entry<Map.Entry<String, LangTag>, Entry>> it = this.idTokenClaims.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Map.Entry<String, LangTag>, Entry> reqEntry = it.next();
            if (!reqEntry.getKey().getKey().equals(claimName)) continue;
            removedClaims.add(reqEntry.getValue());
            it.remove();
        }
        return Collections.unmodifiableCollection(removedClaims);
    }

    public void addUserInfoClaim(String claimName) {
        this.addUserInfoClaim(claimName, ClaimRequirement.VOLUNTARY);
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement) {
        this.addUserInfoClaim(claimName, requirement, null);
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag) {
        this.addUserInfoClaim(claimName, requirement, langTag, (String)null);
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag, String value) {
        this.addUserInfoClaim(new Entry(claimName, requirement, langTag, value));
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag, String value, Map<String, Object> additionalInformation) {
        this.addUserInfoClaim(new Entry(claimName, requirement, langTag, value, null, additionalInformation));
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values) {
        this.addUserInfoClaim(new Entry(claimName, requirement, langTag, values));
    }

    public void addUserInfoClaim(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values, Map<String, Object> additionalInformation) {
        this.addUserInfoClaim(new Entry(claimName, requirement, langTag, null, values, additionalInformation));
    }

    public void addUserInfoClaim(Entry entry) {
        AbstractMap.SimpleImmutableEntry<String, LangTag> key = new AbstractMap.SimpleImmutableEntry<String, LangTag>(entry.getClaimName(), entry.getLangTag());
        this.userInfoClaims.put(key, entry);
    }

    public Collection<Entry> getUserInfoClaims() {
        return Collections.unmodifiableCollection(this.userInfoClaims.values());
    }

    public Set<String> getUserInfoClaimNames(boolean withLangTag) {
        HashSet<String> names = new HashSet<String>();
        for (Entry en : this.userInfoClaims.values()) {
            names.add(en.getClaimName(withLangTag));
        }
        return Collections.unmodifiableSet(names);
    }

    public Entry removeUserInfoClaim(String claimName, LangTag langTag) {
        AbstractMap.SimpleImmutableEntry<String, LangTag> key = new AbstractMap.SimpleImmutableEntry<String, LangTag>(claimName, langTag);
        return this.userInfoClaims.remove(key);
    }

    public Collection<Entry> removeUserInfoClaims(String claimName) {
        LinkedList<Entry> removedClaims = new LinkedList<Entry>();
        Iterator<Map.Entry<Map.Entry<String, LangTag>, Entry>> it = this.userInfoClaims.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Map.Entry<String, LangTag>, Entry> reqEntry = it.next();
            if (!reqEntry.getKey().getKey().equals(claimName)) continue;
            removedClaims.add(reqEntry.getValue());
            it.remove();
        }
        return Collections.unmodifiableCollection(removedClaims);
    }

    public JSONObject toJSONObject() {
        Collection<Entry> userInfoEntries;
        JSONObject o = new JSONObject();
        Collection<Entry> idTokenEntries = this.getIDTokenClaims();
        if (!idTokenEntries.isEmpty()) {
            o.put((Object)"id_token", (Object)Entry.toJSONObject(idTokenEntries));
        }
        if (!(userInfoEntries = this.getUserInfoClaims()).isEmpty()) {
            o.put((Object)"userinfo", (Object)Entry.toJSONObject(userInfoEntries));
        }
        return o;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope) {
        return ClaimsRequest.resolve(responseType, scope, Collections.emptyMap());
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, Map<Scope.Value, Map<String, Map<String, Object>>> customClaims) {
        boolean switchToIDToken = responseType.contains(OIDCResponseTypeValue.ID_TOKEN) && !responseType.contains(ResponseType.Value.CODE) && !responseType.contains(ResponseType.Value.TOKEN);
        ClaimsRequest claimsRequest = new ClaimsRequest();
        if (scope == null) {
            return claimsRequest;
        }
        for (Scope.Value value : scope) {
            Set<Entry> entries;
            if (value.equals(OIDCScopeValue.PROFILE)) {
                entries = OIDCScopeValue.PROFILE.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.EMAIL)) {
                entries = OIDCScopeValue.EMAIL.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.PHONE)) {
                entries = OIDCScopeValue.PHONE.toClaimsRequestEntries();
            } else if (value.equals(OIDCScopeValue.ADDRESS)) {
                entries = OIDCScopeValue.ADDRESS.toClaimsRequestEntries();
            } else {
                Map<String, Map<String, Object>> claimNames;
                if (customClaims == null || !customClaims.containsKey(value) || (claimNames = customClaims.get(value)) == null || claimNames.isEmpty()) continue;
                entries = new HashSet<Entry>();
                for (Map.Entry<String, Map<String, Object>> claimName : claimNames.entrySet()) {
                    String key = claimName.getKey();
                    ClaimRequirement requirement = ClaimRequirement.VOLUNTARY;
                    String name = key;
                    LangTag langTag = null;
                    if (key.contains("#")) {
                        String[] parts = key.split("#", 2);
                        name = parts[0];
                        try {
                            langTag = LangTag.parse((String)parts[1]);
                        }
                        catch (LangTagException e) {
                            continue;
                        }
                    }
                    if (claimName.getValue() != null) {
                        List<String> values;
                        Map<String, Object> additionalInformation;
                        if (claimName.getValue().containsKey("essential") && claimName.getValue().get("essential") != null && claimName.getValue().get("essential") instanceof Boolean && ((Boolean)claimName.getValue().get("essential")).booleanValue()) {
                            requirement = ClaimRequirement.ESSENTIAL;
                        }
                        if (claimName.getValue().containsKey("value") && claimName.getValue().get("value") != null && claimName.getValue().get("value") instanceof String) {
                            String claimValue = (String)claimName.getValue().get("value");
                            additionalInformation = ClaimsRequest.resolveAdditionalInformationForClaim(new HashMap<String, Object>(claimNames.get(key)));
                            entries.add(new Entry(name, requirement, langTag, claimValue, null, additionalInformation));
                            continue;
                        }
                        if (claimName.getValue().containsKey("values") && claimName.getValue().get("values") != null && claimName.getValue().get("values") instanceof String[]) {
                            values = Arrays.asList((String[])claimName.getValue().get("values"));
                            additionalInformation = ClaimsRequest.resolveAdditionalInformationForClaim(new HashMap<String, Object>(claimNames.get(key)));
                            entries.add(new Entry(name, requirement, langTag, null, values, additionalInformation));
                            continue;
                        }
                        if (!claimName.getValue().containsKey("values") || claimName.getValue().get("values") == null || !(claimName.getValue().get("values") instanceof Collection)) continue;
                        values = new ArrayList<String>();
                        for (Object collectionValue : (Collection)claimName.getValue().get("values")) {
                            if (!(collectionValue instanceof String)) continue;
                            values.add((String)collectionValue);
                        }
                        additionalInformation = ClaimsRequest.resolveAdditionalInformationForClaim(new HashMap<String, Object>(claimNames.get(key)));
                        entries.add(new Entry(name, requirement, langTag, null, values, additionalInformation));
                        continue;
                    }
                    entries.add(new Entry(key, ClaimRequirement.VOLUNTARY));
                }
            }
            for (Entry en : entries) {
                if (switchToIDToken) {
                    claimsRequest.addIDTokenClaim(en);
                    continue;
                }
                claimsRequest.addUserInfoClaim(en);
            }
        }
        return claimsRequest;
    }

    private static Map<String, Object> resolveAdditionalInformationForClaim(Map<String, Object> customClaims) {
        customClaims.remove("essential");
        customClaims.remove("value");
        customClaims.remove("values");
        return customClaims.isEmpty() ? null : customClaims;
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, ClaimsRequest claimsRequest) {
        return ClaimsRequest.resolve(responseType, scope, claimsRequest, Collections.emptyMap());
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, ClaimsRequest claimsRequest, Map<Scope.Value, Map<String, Map<String, Object>>> customClaims) {
        ClaimsRequest mergedClaimsRequest = ClaimsRequest.resolve(responseType, scope, customClaims);
        mergedClaimsRequest.add(claimsRequest);
        return mergedClaimsRequest;
    }

    public static ClaimsRequest resolve(AuthenticationRequest authRequest) {
        return ClaimsRequest.resolve(authRequest.getResponseType(), authRequest.getScope(), authRequest.getClaims());
    }

    public static ClaimsRequest parse(JSONObject jsonObject) {
        ClaimsRequest claimsRequest = new ClaimsRequest();
        try {
            if (jsonObject.containsKey((Object)"id_token")) {
                JSONObject idTokenObject = (JSONObject)jsonObject.get((Object)"id_token");
                Collection<Entry> idTokenClaims = Entry.parseEntries(idTokenObject);
                for (Entry entry : idTokenClaims) {
                    claimsRequest.addIDTokenClaim(entry);
                }
            }
            if (jsonObject.containsKey((Object)"userinfo")) {
                JSONObject userInfoObject = (JSONObject)jsonObject.get((Object)"userinfo");
                Collection<Entry> userInfoClaims = Entry.parseEntries(userInfoObject);
                for (Entry entry : userInfoClaims) {
                    claimsRequest.addUserInfoClaim(entry);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return claimsRequest;
    }

    public static ClaimsRequest parse(String json) throws ParseException {
        return ClaimsRequest.parse(JSONObjectUtils.parse(json));
    }

    @Immutable
    public static class Entry {
        private final String claimName;
        private final ClaimRequirement requirement;
        private final LangTag langTag;
        private final String value;
        private final List<String> values;
        private final Map<String, Object> additionalInformation;

        public Entry(String claimName, LangTag langTag) {
            this(claimName, ClaimRequirement.VOLUNTARY, langTag, null, null);
        }

        public Entry(String claimName, ClaimRequirement requirement) {
            this(claimName, requirement, null, null, null);
        }

        public Entry(String claimName, ClaimRequirement requirement, LangTag langTag, String value) {
            this(claimName, requirement, langTag, value, null);
        }

        public Entry(String claimName, ClaimRequirement requirement, LangTag langTag, List<String> values) {
            this(claimName, requirement, langTag, null, values, null);
        }

        private Entry(String claimName, ClaimRequirement requirement, LangTag langTag, String value, List<String> values) {
            this(claimName, requirement, langTag, value, values, null);
        }

        private Entry(String claimName, ClaimRequirement requirement, LangTag langTag, String value, List<String> values, Map<String, Object> additionalInformation) {
            if (claimName == null) {
                throw new IllegalArgumentException("The claim name must not be null");
            }
            this.claimName = claimName;
            if (requirement == null) {
                throw new IllegalArgumentException("The claim requirement must not be null");
            }
            this.requirement = requirement;
            this.langTag = langTag;
            if (value != null && values == null) {
                this.value = value;
                this.values = null;
            } else if (value == null && values != null) {
                this.value = null;
                this.values = values;
            } else if (value == null && values == null) {
                this.value = null;
                this.values = null;
            } else {
                throw new IllegalArgumentException("Either value or values must be specified, but not both");
            }
            this.additionalInformation = additionalInformation;
        }

        public String getClaimName() {
            return this.claimName;
        }

        public String getClaimName(boolean withLangTag) {
            if (withLangTag && this.langTag != null) {
                return this.claimName + "#" + this.langTag.toString();
            }
            return this.claimName;
        }

        public ClaimRequirement getClaimRequirement() {
            return this.requirement;
        }

        public LangTag getLangTag() {
            return this.langTag;
        }

        public String getValue() {
            return this.value;
        }

        public List<String> getValues() {
            return this.values;
        }

        public Map<String, Object> getAdditionalInformation() {
            return this.additionalInformation;
        }

        public static JSONObject toJSONObject(Collection<Entry> entries) {
            JSONObject o = new JSONObject();
            for (Entry entry : entries) {
                JSONObject entrySpec = null;
                if (entry.getValue() != null) {
                    entrySpec = new JSONObject();
                    entrySpec.put((Object)"value", (Object)entry.getValue());
                }
                if (entry.getValues() != null) {
                    entrySpec = new JSONObject();
                    entrySpec.put((Object)"values", entry.getValues());
                }
                if (entry.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL)) {
                    if (entrySpec == null) {
                        entrySpec = new JSONObject();
                    }
                    entrySpec.put((Object)"essential", (Object)true);
                }
                if (entry.getAdditionalInformation() != null) {
                    if (entrySpec == null) {
                        entrySpec = new JSONObject();
                    }
                    for (Map.Entry<String, Object> additionalInformationEntry : entry.getAdditionalInformation().entrySet()) {
                        entrySpec.put((Object)additionalInformationEntry.getKey(), additionalInformationEntry.getValue());
                    }
                }
                o.put((Object)entry.getClaimName(true), (Object)entrySpec);
            }
            return o;
        }

        public static Collection<Entry> parseEntries(JSONObject jsonObject) {
            LinkedList<Entry> entries = new LinkedList<Entry>();
            if (jsonObject.isEmpty()) {
                return entries;
            }
            for (Map.Entry member : jsonObject.entrySet()) {
                String claimName;
                LangTag langTag;
                block12: {
                    String claimNameWithOptLangTag = (String)member.getKey();
                    langTag = null;
                    if (claimNameWithOptLangTag.contains("#")) {
                        String[] parts = claimNameWithOptLangTag.split("#", 2);
                        claimName = parts[0];
                        try {
                            langTag = LangTag.parse((String)parts[1]);
                            break block12;
                        }
                        catch (LangTagException e) {
                            continue;
                        }
                    }
                    claimName = claimNameWithOptLangTag;
                }
                if (member.getValue() == null) {
                    entries.add(new Entry(claimName, langTag));
                    continue;
                }
                try {
                    Map<String, Object> additionalInformation;
                    boolean isEssential;
                    JSONObject entrySpec = (JSONObject)member.getValue();
                    ClaimRequirement requirement = ClaimRequirement.VOLUNTARY;
                    if (entrySpec.containsKey((Object)"essential") && (isEssential = ((Boolean)entrySpec.get((Object)"essential")).booleanValue())) {
                        requirement = ClaimRequirement.ESSENTIAL;
                    }
                    if (entrySpec.containsKey((Object)"value")) {
                        String expectedValue = (String)entrySpec.get((Object)"value");
                        additionalInformation = Entry.getAdditionalInformationFromClaim(entrySpec);
                        entries.add(new Entry(claimName, requirement, langTag, expectedValue, null, additionalInformation));
                        continue;
                    }
                    if (entrySpec.containsKey((Object)"values")) {
                        LinkedList<String> expectedValues = new LinkedList<String>();
                        for (Object v : (List)entrySpec.get((Object)"values")) {
                            expectedValues.add((String)v);
                        }
                        additionalInformation = Entry.getAdditionalInformationFromClaim(entrySpec);
                        entries.add(new Entry(claimName, requirement, langTag, null, expectedValues, additionalInformation));
                        continue;
                    }
                    Map<String, Object> additionalInformation2 = Entry.getAdditionalInformationFromClaim(entrySpec);
                    entries.add(new Entry(claimName, requirement, langTag, null, null, additionalInformation2));
                }
                catch (Exception exception) {}
            }
            return entries;
        }

        private static Map<String, Object> getAdditionalInformationFromClaim(JSONObject entrySpec) {
            List<String> keysToRemove = Arrays.asList("essential", "value", "values");
            entrySpec.keySet().removeAll(keysToRemove);
            HashMap<String, Object> additionalClaimInformation = new HashMap<String, Object>();
            for (Map.Entry additionalClaimInformationEntry : entrySpec.entrySet()) {
                additionalClaimInformation.put((String)additionalClaimInformationEntry.getKey(), additionalClaimInformationEntry.getValue());
            }
            return additionalClaimInformation.isEmpty() ? null : additionalClaimInformation;
        }
    }
}

