/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.assurance;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import com.nimbusds.openid.connect.sdk.assurance.IdentityTrustFramework;
import com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

@Immutable
public final class IdentityVerification
implements JSONAware {
    private final IdentityTrustFramework trustFramework;
    private final DateWithTimeZoneOffset time;
    private final String verificationProcess;
    private final List<IdentityEvidence> evidence;

    public IdentityVerification(IdentityTrustFramework trustFramework, DateWithTimeZoneOffset time, String verificationProcess, List<IdentityEvidence> evidence) {
        if (trustFramework == null) {
            throw new IllegalArgumentException("The trust framework must not be null");
        }
        this.trustFramework = trustFramework;
        this.time = time;
        this.verificationProcess = verificationProcess;
        this.evidence = evidence;
    }

    public IdentityTrustFramework getTrustFramework() {
        return this.trustFramework;
    }

    public DateWithTimeZoneOffset getVerificationTime() {
        return this.time;
    }

    public String getVerificationProcess() {
        return this.verificationProcess;
    }

    public List<IdentityEvidence> getEvidence() {
        return this.evidence;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"trust_framework", (Object)this.getTrustFramework().getValue());
        if (this.getVerificationTime() != null) {
            o.put((Object)"time", (Object)this.getVerificationTime().toISO8601String());
        }
        if (this.getVerificationProcess() != null) {
            o.put((Object)"verification_process", (Object)this.getVerificationProcess());
        }
        if (this.getEvidence() != null) {
            JSONArray evidenceArray = new JSONArray();
            for (IdentityEvidence ev : this.getEvidence()) {
                evidenceArray.add((Object)ev.toJSONObject());
            }
            o.put((Object)"evidence", (Object)evidenceArray);
        }
        return o;
    }

    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public static IdentityVerification parse(JSONObject jsonObject) throws ParseException {
        IdentityTrustFramework trustFramework = new IdentityTrustFramework(JSONObjectUtils.getString(jsonObject, "trust_framework"));
        DateWithTimeZoneOffset time = null;
        if (jsonObject.get((Object)"time") != null) {
            time = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getString(jsonObject, "time"));
        }
        String verificationProcess = null;
        if (jsonObject.get((Object)"verification_process") != null) {
            verificationProcess = JSONObjectUtils.getString(jsonObject, "verification_process");
        }
        LinkedList<IdentityEvidence> evidence = null;
        if (jsonObject.get((Object)"evidence") != null) {
            evidence = new LinkedList<IdentityEvidence>();
            JSONArray jsonArray = JSONObjectUtils.getJSONArray(jsonObject, "evidence");
            for (JSONObject item : JSONArrayUtils.toJSONObjectList(jsonArray)) {
                evidence.add(IdentityEvidence.parse(item));
            }
        }
        return new IdentityVerification(trustFramework, time, verificationProcess, evidence);
    }
}

