/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.assurance.evidences;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.date.SimpleDate;
import com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import com.nimbusds.openid.connect.sdk.claims.Address;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class UtilityBillEvidence
extends IdentityEvidence {
    private final String providerName;
    private final Address providerAddress;
    private final SimpleDate date;

    public UtilityBillEvidence(String providerName, Address providerAddress, SimpleDate date) {
        super(IdentityEvidenceType.UTILITY_BILL);
        if (providerName == null) {
            throw new IllegalArgumentException("The utility provider name must not be null");
        }
        this.providerName = providerName;
        if (providerAddress == null) {
            throw new IllegalArgumentException("The utility provider address must not be null");
        }
        this.providerAddress = providerAddress;
        if (date == null) {
            throw new IllegalArgumentException("The utility bill date must not be null");
        }
        this.date = date;
    }

    public String getUtilityProviderName() {
        return this.providerName;
    }

    public Address getUtilityProviderAddress() {
        return this.providerAddress;
    }

    public SimpleDate getUtilityBillDate() {
        return this.date;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        JSONObject providerDetails = new JSONObject();
        providerDetails.put((Object)"name", (Object)this.getUtilityProviderName());
        providerDetails.putAll((Map)this.getUtilityProviderAddress().toJSONObject());
        o.put((Object)"provider", (Object)providerDetails);
        o.put((Object)"date", (Object)this.getUtilityBillDate().toISO8601String());
        return o;
    }

    public static UtilityBillEvidence parse(JSONObject jsonObject) throws ParseException {
        UtilityBillEvidence.ensureType(IdentityEvidenceType.UTILITY_BILL, jsonObject);
        JSONObject providerDetails = JSONObjectUtils.getJSONObject(jsonObject, "provider");
        String providerName = JSONObjectUtils.getString(providerDetails, "name");
        providerDetails.remove((Object)"name");
        Address providerAddress = Address.parse(providerDetails.toJSONString());
        SimpleDate date = SimpleDate.parseISO8601String(JSONObjectUtils.getString(jsonObject, "date"));
        return new UtilityBillEvidence(providerName, providerAddress, date);
    }
}

