/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.trust;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.trust.DefaultEntityStatementRetriever;
import com.nimbusds.openid.connect.sdk.federation.trust.DefaultTrustChainRetriever;
import com.nimbusds.openid.connect.sdk.federation.trust.EntityStatementRetriever;
import com.nimbusds.openid.connect.sdk.federation.trust.ResolveException;
import com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import com.nimbusds.openid.connect.sdk.federation.trust.TrustChainSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class TrustChainResolver {
    private final Map<EntityID, JWKSet> trustAnchors;
    private final EntityStatementRetriever statementRetriever;

    public TrustChainResolver(EntityID trustAnchor, JWKSet trustAnchorJWKSet) {
        this(Collections.singletonMap(trustAnchor, trustAnchorJWKSet), new DefaultEntityStatementRetriever());
    }

    public TrustChainResolver(Map<EntityID, JWKSet> trustAnchors, int httpConnectTimeoutMs, int httpReadTimeoutMs) {
        this(trustAnchors, new DefaultEntityStatementRetriever(httpConnectTimeoutMs, httpReadTimeoutMs));
    }

    public TrustChainResolver(Map<EntityID, JWKSet> trustAnchors, EntityStatementRetriever statementRetriever) {
        if (MapUtils.isEmpty(trustAnchors)) {
            throw new IllegalArgumentException("The trust anchors map must not be empty or null");
        }
        this.trustAnchors = trustAnchors;
        if (statementRetriever == null) {
            throw new IllegalArgumentException("The entity statement retriever must not be null");
        }
        this.statementRetriever = statementRetriever;
    }

    public Map<EntityID, JWKSet> getTrustAnchors() {
        return Collections.unmodifiableMap(this.trustAnchors);
    }

    public EntityStatementRetriever getEntityStatementRetriever() {
        return this.statementRetriever;
    }

    public TrustChainSet resolveTrustChains(EntityID target) throws ResolveException {
        if (this.trustAnchors.get(target) != null) {
            throw new ResolveException("Target is trust anchor");
        }
        DefaultTrustChainRetriever retriever = new DefaultTrustChainRetriever(this.statementRetriever);
        TrustChainSet fetchedTrustChains = retriever.fetch(target, this.trustAnchors.keySet());
        if (fetchedTrustChains.isEmpty()) {
            if (retriever.getAccumulatedExceptions().isEmpty()) {
                throw new ResolveException("No trust chain leading up to a trust anchor");
            }
            if (retriever.getAccumulatedExceptions().size() == 1) {
                Throwable cause = retriever.getAccumulatedExceptions().get(0);
                throw new ResolveException("Couldn't resolve trust chain: " + cause.getMessage(), cause);
            }
            throw new ResolveException("Couldn't resolve trust chain due to multiple causes", retriever.getAccumulatedExceptions());
        }
        LinkedList<Throwable> verificationExceptions = new LinkedList<Throwable>();
        TrustChainSet verifiedTrustChains = new TrustChainSet();
        for (TrustChain chain : fetchedTrustChains) {
            EntityID anchor = chain.getTrustAnchorEntityID();
            JWKSet anchorJWKSet = this.trustAnchors.get(anchor);
            if (anchorJWKSet == null) continue;
            try {
                chain.verifySignatures(anchorJWKSet);
            }
            catch (JOSEException | BadJOSEException e) {
                verificationExceptions.add(e);
                continue;
            }
            verifiedTrustChains.add(chain);
        }
        if (verifiedTrustChains.isEmpty()) {
            LinkedList<Throwable> accumulatedExceptions = new LinkedList<Throwable>(retriever.getAccumulatedExceptions());
            accumulatedExceptions.addAll(verificationExceptions);
            if (verificationExceptions.size() == 1) {
                Throwable cause = (Throwable)verificationExceptions.get(0);
                throw new ResolveException("Couldn't resolve trust chain: " + cause.getMessage(), accumulatedExceptions);
            }
            throw new ResolveException("Couldn't resolve trust chain due to multiple causes", accumulatedExceptions);
        }
        return verifiedTrustChains;
    }
}

