/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.policy;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicyEntry;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationCombinationValidator;
import com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class MetadataPolicy
implements JSONAware {
    private final Map<String, List<PolicyOperation>> entries = new LinkedHashMap<String, List<PolicyOperation>>();

    public void put(String parameterName, PolicyOperation policyOperation) {
        this.put(new MetadataPolicyEntry(parameterName, Collections.singletonList(policyOperation)));
    }

    public void put(String parameterName, List<PolicyOperation> policyOperations) {
        this.put(new MetadataPolicyEntry(parameterName, policyOperations));
    }

    public void put(MetadataPolicyEntry entry) {
        this.entries.put(entry.getKey(), (List<PolicyOperation>)entry.getValue());
    }

    public List<PolicyOperation> get(String parameterName) {
        return this.entries.get(parameterName);
    }

    public MetadataPolicyEntry getEntry(String parameterName) {
        List<PolicyOperation> policyOperations = this.entries.get(parameterName);
        if (policyOperations == null) {
            return null;
        }
        return new MetadataPolicyEntry(parameterName, policyOperations);
    }

    public Set<MetadataPolicyEntry> entrySet() {
        LinkedHashSet<MetadataPolicyEntry> set = new LinkedHashSet<MetadataPolicyEntry>();
        for (Map.Entry<String, List<PolicyOperation>> en : this.entries.entrySet()) {
            set.add(new MetadataPolicyEntry(en.getKey(), en.getValue()));
        }
        return set;
    }

    public List<PolicyOperation> remove(String parameterName) {
        return this.entries.remove(parameterName);
    }

    public Map<String, Object> toJSONObject() {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        for (MetadataPolicyEntry en : this.entrySet()) {
            jsonObject.put(en.getKey(), en.toJSONObject());
        }
        return jsonObject;
    }

    public String toJSONString() {
        return JSONObject.toJSONString(this.toJSONObject());
    }

    public static MetadataPolicy parse(JSONObject policySpec, PolicyOperationFactory factory, PolicyOperationCombinationValidator combinationValidator) throws ParseException, PolicyViolationException {
        MetadataPolicy metadataPolicy = new MetadataPolicy();
        for (String parameterName : policySpec.keySet()) {
            JSONObject entrySpec = JSONObjectUtils.getJSONObject(policySpec, parameterName);
            metadataPolicy.put(MetadataPolicyEntry.parse(parameterName, entrySpec, factory, combinationValidator));
        }
        return metadataPolicy;
    }

    public static MetadataPolicy parse(JSONObject policySpec) throws ParseException, PolicyViolationException {
        return MetadataPolicy.parse(policySpec, MetadataPolicyEntry.DEFAULT_POLICY_OPERATION_FACTORY, MetadataPolicyEntry.DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public static MetadataPolicy parse(String policySpec, PolicyOperationFactory factory, PolicyOperationCombinationValidator combinationValidator) throws ParseException, PolicyViolationException {
        return MetadataPolicy.parse(JSONObjectUtils.parse(policySpec), factory, combinationValidator);
    }

    public static MetadataPolicy parse(String policySpec) throws ParseException, PolicyViolationException {
        return MetadataPolicy.parse(policySpec, MetadataPolicyEntry.DEFAULT_POLICY_OPERATION_FACTORY, MetadataPolicyEntry.DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }
}

