/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class GrantType
extends Identifier {
    public static final GrantType AUTHORIZATION_CODE = new GrantType("authorization_code", false, true, new HashSet<String>(Arrays.asList("code", "redirect_uri", "code_verifier")));
    public static final GrantType IMPLICIT = new GrantType("implicit", false, true, Collections.emptySet());
    public static final GrantType REFRESH_TOKEN = new GrantType("refresh_token", false, false, Collections.singleton("refresh_token"));
    public static final GrantType PASSWORD = new GrantType("password", false, false, new HashSet<String>(Arrays.asList("username", "password")));
    public static final GrantType CLIENT_CREDENTIALS = new GrantType("client_credentials", true, true, Collections.emptySet());
    public static final GrantType JWT_BEARER = new GrantType("urn:ietf:params:oauth:grant-type:jwt-bearer", false, false, Collections.singleton("assertion"));
    public static final GrantType SAML2_BEARER = new GrantType("urn:ietf:params:oauth:grant-type:saml2-bearer", false, false, Collections.singleton("assertion"));
    public static final GrantType DEVICE_CODE = new GrantType("urn:ietf:params:oauth:grant-type:device_code", false, true, Collections.singleton("device_code"));
    public static final GrantType CIBA = new GrantType("urn:openid:params:grant-type:ciba", true, true, Collections.singleton("auth_req_id"));
    private static final long serialVersionUID = -5367937758427680765L;
    private final boolean requiresClientAuth;
    private final boolean requiresClientID;
    private final Set<String> requestParamNames;

    public GrantType(String value) {
        this(value, false, false, Collections.emptySet());
    }

    private GrantType(String value, boolean requiresClientAuth, boolean requiresClientID, Set<String> requestParamNames) {
        super(value);
        this.requiresClientAuth = requiresClientAuth;
        this.requiresClientID = requiresClientID;
        this.requestParamNames = requestParamNames == null ? Collections.emptySet() : Collections.unmodifiableSet(requestParamNames);
    }

    public boolean requiresClientAuthentication() {
        return this.requiresClientAuth;
    }

    public boolean requiresClientID() {
        return this.requiresClientID;
    }

    public Set<String> getRequestParameterNames() {
        return this.requestParamNames;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GrantType && this.toString().equals(object.toString());
    }

    public static GrantType parse(String value) throws ParseException {
        GrantType grantType;
        try {
            grantType = new GrantType(value);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage());
        }
        if (grantType.equals(AUTHORIZATION_CODE)) {
            return AUTHORIZATION_CODE;
        }
        if (grantType.equals(IMPLICIT)) {
            return IMPLICIT;
        }
        if (grantType.equals(REFRESH_TOKEN)) {
            return REFRESH_TOKEN;
        }
        if (grantType.equals(PASSWORD)) {
            return PASSWORD;
        }
        if (grantType.equals(CLIENT_CREDENTIALS)) {
            return CLIENT_CREDENTIALS;
        }
        if (grantType.equals(JWT_BEARER)) {
            return JWT_BEARER;
        }
        if (grantType.equals(SAML2_BEARER)) {
            return SAML2_BEARER;
        }
        if (grantType.equals(DEVICE_CODE)) {
            return DEVICE_CODE;
        }
        if (grantType.equals(CIBA)) {
            return CIBA;
        }
        return grantType;
    }
}

