/*
 * oauth2-oidc-sdk
 *
 * Copyright 2012-2020, Connect2id Ltd and contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use
 * this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package com.nimbusds.openid.connect.sdk.federation.policy.operations;


import com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;


/**
 * Policy operation factory.
 *
 * <p>To support non-standard policy operations on metadata parameters consider
 * overriding {@link DefaultPolicyOperationFactory#createForName}.
 *
 * <p>Related specifications:
 *
 * <ul>
 *     <li>OpenID Connect Federation 1.0, section 4.1.
 * </ul>
 */
public interface PolicyOperationFactory {
	
	
	/**
	 * Creates a policy operation for the specified name.
	 *
	 * @param name The name. Must not be {@code null}.
	 *
	 * @return The policy operation, {@code null} if not supported.
	 */
	PolicyOperation createForName(OperationName name);
}
