/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class ErrorObject
implements Serializable {
    private static final long serialVersionUID = -361808781364656206L;
    private final String code;
    private final String description;
    private final int httpStatusCode;
    private final URI uri;
    private final Map<String, String> customParams;

    public ErrorObject(String code) {
        this(code, null, 0, null);
    }

    public ErrorObject(String code, String description) {
        this(code, description, 0, null);
    }

    public ErrorObject(String code, String description, int httpStatusCode) {
        this(code, description, httpStatusCode, null);
    }

    public ErrorObject(String code, String description, int httpStatusCode, URI uri) {
        this(code, description, httpStatusCode, uri, null);
    }

    public ErrorObject(String code, String description, int httpStatusCode, URI uri, Map<String, String> customParams) {
        if (!ErrorObject.isLegal(code)) {
            throw new IllegalArgumentException("Illegal char(s) in code, see RFC 6749, section 5.2");
        }
        this.code = code;
        if (!ErrorObject.isLegal(description)) {
            throw new IllegalArgumentException("Illegal char(s) in description, see RFC 6749, section 5.2");
        }
        this.description = description;
        this.httpStatusCode = httpStatusCode;
        this.uri = uri;
        this.customParams = customParams;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public ErrorObject setDescription(String description) {
        return new ErrorObject(this.getCode(), description, this.getHTTPStatusCode(), this.getURI(), this.getCustomParams());
    }

    public ErrorObject appendDescription(String text) {
        String newDescription = this.getDescription() != null ? this.getDescription() + text : text;
        return new ErrorObject(this.getCode(), newDescription, this.getHTTPStatusCode(), this.getURI(), this.getCustomParams());
    }

    public int getHTTPStatusCode() {
        return this.httpStatusCode;
    }

    public ErrorObject setHTTPStatusCode(int httpStatusCode) {
        return new ErrorObject(this.getCode(), this.getDescription(), httpStatusCode, this.getURI(), this.getCustomParams());
    }

    public URI getURI() {
        return this.uri;
    }

    public ErrorObject setURI(URI uri) {
        return new ErrorObject(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), uri, this.getCustomParams());
    }

    public Map<String, String> getCustomParams() {
        if (MapUtils.isNotEmpty(this.customParams)) {
            return Collections.unmodifiableMap(this.customParams);
        }
        return Collections.emptyMap();
    }

    public ErrorObject setCustomParams(Map<String, String> customParams) {
        return new ErrorObject(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), customParams);
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.getCode() != null) {
            o.put((Object)"error", (Object)this.getCode());
        }
        if (this.getDescription() != null) {
            o.put((Object)"error_description", (Object)this.getDescription());
        }
        if (this.getURI() != null) {
            o.put((Object)"error_uri", (Object)this.getURI().toString());
        }
        if (!this.getCustomParams().isEmpty()) {
            o.putAll(this.getCustomParams());
        }
        return o;
    }

    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (this.getCode() != null) {
            params.put("error", Collections.singletonList(this.getCode()));
        }
        if (this.getDescription() != null) {
            params.put("error_description", Collections.singletonList(this.getDescription()));
        }
        if (this.getURI() != null) {
            params.put("error_uri", Collections.singletonList(this.getURI().toString()));
        }
        if (!this.getCustomParams().isEmpty()) {
            for (Map.Entry<String, String> en : this.getCustomParams().entrySet()) {
                params.put(en.getKey(), Collections.singletonList(en.getValue()));
            }
        }
        return params;
    }

    public HTTPResponse toHTTPResponse() {
        int statusCode = this.getHTTPStatusCode() > 0 ? this.getHTTPStatusCode() : 400;
        HTTPResponse httpResponse = new HTTPResponse(statusCode);
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        if (this.getCode() != null) {
            httpResponse.setEntityContentType(ContentType.APPLICATION_JSON);
            httpResponse.setContent(this.toJSONObject().toJSONString());
        }
        return httpResponse;
    }

    public String toString() {
        return this.code != null ? this.code : "null";
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : "null".hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ErrorObject && this.toString().equals(object.toString());
    }

    public static ErrorObject parse(JSONObject jsonObject) {
        String code = null;
        try {
            code = JSONObjectUtils.getString(jsonObject, "error", null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (!ErrorObject.isLegal(code)) {
            code = null;
        }
        String description = null;
        try {
            description = JSONObjectUtils.getString(jsonObject, "error_description", null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (!ErrorObject.isLegal(description)) {
            description = null;
        }
        URI uri = null;
        try {
            uri = JSONObjectUtils.getURI(jsonObject, "error_uri", null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        HashMap customParams = null;
        for (Map.Entry en : jsonObject.entrySet()) {
            if ("error".equals(en.getKey()) || "error_description".equals(en.getKey()) || "error_uri".equals(en.getKey()) || en.getValue() != null && !(en.getValue() instanceof String)) continue;
            if (customParams == null) {
                customParams = new HashMap();
            }
            customParams.put(en.getKey(), (String)en.getValue());
        }
        return new ErrorObject(code, description, 0, uri, customParams);
    }

    public static ErrorObject parse(Map<String, List<String>> params) {
        String code = MultivaluedMapUtils.getFirstValue(params, "error");
        String description = MultivaluedMapUtils.getFirstValue(params, "error_description");
        String uriString = MultivaluedMapUtils.getFirstValue(params, "error_uri");
        if (!ErrorObject.isLegal(code)) {
            code = null;
        }
        if (!ErrorObject.isLegal(description)) {
            description = null;
        }
        URI uri = null;
        if (uriString != null) {
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        HashMap<String, String> customParams = null;
        for (Map.Entry<String, List<String>> en : params.entrySet()) {
            if ("error".equals(en.getKey()) || "error_description".equals(en.getKey()) || "error_uri".equals(en.getKey())) continue;
            if (customParams == null) {
                customParams = new HashMap<String, String>();
            }
            if (en.getValue() == null) {
                customParams.put(en.getKey(), null);
                continue;
            }
            if (en.getValue().isEmpty()) continue;
            customParams.put(en.getKey(), en.getValue().get(0));
        }
        return new ErrorObject(code, description, 0, uri, customParams);
    }

    public static ErrorObject parse(HTTPResponse httpResponse) {
        JSONObject jsonObject;
        try {
            jsonObject = httpResponse.getContentAsJSONObject();
        }
        catch (ParseException e) {
            return new ErrorObject(null, null, httpResponse.getStatusCode());
        }
        ErrorObject intermediary = ErrorObject.parse(jsonObject);
        return new ErrorObject(intermediary.getCode(), intermediary.description, httpResponse.getStatusCode(), intermediary.getURI(), intermediary.getCustomParams());
    }

    public static boolean isLegal(String s) {
        if (s == null) {
            return true;
        }
        for (char c : s.toCharArray()) {
            if (ErrorObject.isLegal(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegal(char c) {
        if (c > '\u007f') {
            return false;
        }
        return c >= ' ' && c <= '!' || c >= '#' && c <= '[' || c >= ']' && c <= '~';
    }
}

