/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6.cli;

import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.SRP6CryptoParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;

public abstract class SRP6Tool {
    protected BufferedReader console;

    public SRP6Tool() throws IOException {
        InputStreamReader stdin = new InputStreamReader(System.in);
        this.console = new BufferedReader(stdin);
    }

    public String readInput(String def) throws IOException {
        String input = this.console.readLine();
        if (input == null || input.isEmpty()) {
            if (def != null) {
                return def;
            }
            throw new IOException("Missing input");
        }
        return input.trim();
    }

    public String readInput() throws IOException {
        return this.readInput(null);
    }

    public BigInteger readBigInteger() throws IOException {
        BigInteger bigInt = BigIntegerUtils.fromHex(this.readInput());
        if (bigInt == null) {
            throw new IOException("Bad hex encoding");
        }
        return bigInt;
    }

    public SRP6CryptoParams getConfig(String prefix) throws IOException {
        BigInteger g;
        BigInteger N;
        System.out.println(prefix + "Enter prime 'N' (hex): ");
        System.out.println(prefix + "\t1 = select precomputed 256-bit");
        System.out.println(prefix + "\t2 = select precomputed 512-bit");
        System.out.println(prefix + "\t3 = select precomputed 768-bit");
        System.out.println(prefix + "\t4 = select precomputed 1024-bit");
        System.out.println(prefix + "\t5 = select precomputed 2048-bit");
        System.out.println(prefix + "\t6 = enter prime 'N' and generator 'g'");
        System.out.println();
        System.out.print(prefix + "Your choice [1]: ");
        String choice = this.readInput("1");
        boolean selectedPrecomputed = true;
        switch (choice) {
            case "1": {
                N = SRP6CryptoParams.N_256;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "2": {
                N = SRP6CryptoParams.N_512;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "3": {
                N = SRP6CryptoParams.N_768;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "4": {
                N = SRP6CryptoParams.N_1024;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "5": {
                N = SRP6CryptoParams.N_2048;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "6": {
                System.out.println();
                System.out.print(prefix + "Enter prime 'N' (hex): ");
                N = this.readBigInteger();
                System.out.print(prefix + "Enter generator 'g' (hex): ");
                g = this.readBigInteger();
                selectedPrecomputed = false;
                break;
            }
            default: {
                throw new IOException("Unknown choice");
            }
        }
        System.out.println();
        if (selectedPrecomputed) {
            System.out.println(prefix + "Selected prime 'N' (hex): " + BigIntegerUtils.toHex(N));
            System.out.println(prefix + "Selected generator 'g' (hex): " + BigIntegerUtils.toHex(g));
            System.out.println();
        }
        System.out.print(prefix + "Enter hash algorithm 'H' [SHA-1]: ");
        String H = this.readInput("SHA-1");
        System.out.println();
        return new SRP6CryptoParams(N, g, H);
    }

    public abstract void run() throws IOException;
}

