/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;

public class ProxyServer {
    private final Protocol protocol;
    private final String host;
    private int port;

    public ProxyServer(Protocol protocol, String host, int port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public ProxyServer(String host, int port) {
        this(Protocol.HTTP, host, port);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getProtocolAsString() {
        return this.protocol.toString();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static final ProxyServer fromProxy(Proxy proxy) {
        if (proxy == null || proxy.type() == Proxy.Type.DIRECT) {
            return null;
        }
        if (proxy.type() != Proxy.Type.HTTP) {
            throw new IllegalArgumentException("Only DIRECT and HTTP Proxies are supported!");
        }
        SocketAddress sa = proxy.address();
        if (!(sa instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Only Internet Address sockets are supported!");
        }
        InetSocketAddress isa = (InetSocketAddress)sa;
        if (isa.isUnresolved()) {
            return new ProxyServer(isa.getHostName(), isa.getPort());
        }
        return new ProxyServer(isa.getAddress().getHostAddress(), isa.getPort());
    }

    public String toString() {
        return String.format("%s://%s:%d", this.protocol.toString(), this.host, this.port);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        HTTP("http"),
        HTTPS("https");

        private final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.getProtocol();
        }
    }
}

