/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.Cookie;
import com.ning.http.client.Headers;
import com.ning.http.client.Part;
import com.ning.http.client.Request;
import com.ning.http.client.RequestType;
import com.ning.http.shaded.com.google.collections.collect.LinkedListMultimap;
import com.ning.http.shaded.com.google.collections.collect.Multimap;
import com.ning.http.shaded.com.google.collections.collect.Multimaps;
import com.ning.http.url.Url;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RequestBuilderBase<T extends RequestBuilderBase<T>> {
    private final Class<T> derived;
    private final RequestImpl request;

    RequestBuilderBase(Class<T> derived, RequestType type) {
        this.derived = derived;
        this.request = new RequestImpl();
        this.request.type = type;
    }

    RequestBuilderBase(Class<T> derived, Request prototype) {
        this.derived = derived;
        this.request = new RequestImpl(prototype);
    }

    public T setUrl(String url) {
        this.request.url = url;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setVirtualHost(String virtualHost) {
        this.request.virtualHost = virtualHost;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeader(String name, String value) {
        this.request.headers.replace(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addHeader(String name, String value) {
        this.request.headers.add(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(Headers headers) {
        this.request.headers = headers == null ? new Headers() : new Headers(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setHeaders(Map<String, Collection<String>> headers) {
        this.request.headers = headers == null ? new Headers() : new Headers(headers);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addCookie(Cookie cookie) {
        this.request.cookies.add(cookie);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    private void resetParameters() {
        this.request.params = null;
    }

    private void resetNonMultipartData() {
        RequestImpl.access$602(this.request, null);
        this.request.stringData = null;
        this.request.streamData = null;
        this.request.entityWriter = null;
        this.request.length = -1L;
    }

    private void resetMultipartData() {
        this.request.parts = null;
    }

    public T setBody(byte[] data) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        RequestImpl.access$602(this.request, data);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(String data) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.stringData = data;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(InputStream stream) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.streamData = stream;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setBody(Request.EntityWriter dataWriter) {
        return this.setBody(dataWriter, -1L);
    }

    public T setBody(Request.EntityWriter dataWriter, long length) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for content");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.entityWriter = dataWriter;
        this.request.length = length;
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addQueryParameter(String name, String value) {
        if (this.request.queryParams == null) {
            this.request.queryParams = LinkedListMultimap.create();
        }
        this.request.queryParams.put(name, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addParameter(String key, String value) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for form parameters");
        }
        this.resetNonMultipartData();
        this.resetMultipartData();
        if (this.request.params == null) {
            this.request.params = LinkedListMultimap.create();
        }
        this.request.params.put(key, value);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setParameters(Multimap<String, String> parameters) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for form parameters");
        }
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.params = LinkedListMultimap.create(parameters);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T setParameters(Map<String, String> parameters) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for form parameters");
        }
        this.resetNonMultipartData();
        this.resetMultipartData();
        this.request.params = LinkedListMultimap.create(Multimaps.forMap(parameters));
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public T addBodyPart(Part part) throws IllegalArgumentException {
        if (this.request.type != RequestType.POST && this.request.type != RequestType.PUT) {
            throw new IllegalArgumentException("Request type has to POST or PUT for parts");
        }
        this.resetParameters();
        this.resetNonMultipartData();
        if (this.request.parts == null) {
            this.request.parts = new ArrayList();
        }
        this.request.parts.add(part);
        return (T)((RequestBuilderBase)this.derived.cast(this));
    }

    public Request build() {
        String contentLength;
        if (this.request.length < 0L && this.request.streamData == null && (this.request.type == RequestType.POST || this.request.type == RequestType.PUT) && (contentLength = this.request.headers.getFirstHeaderValue("Content-Length")) != null) {
            try {
                this.request.length = Long.parseLong(contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequestImpl
    implements Request {
        private RequestType type;
        private String url;
        private Headers headers = new Headers();
        private Collection<Cookie> cookies = new ArrayList<Cookie>();
        private byte[] byteData;
        private String stringData;
        private InputStream streamData;
        private Request.EntityWriter entityWriter;
        private Multimap<String, String> params;
        private List<Part> parts;
        private String virtualHost;
        private long length = -1L;
        public Multimap<String, String> queryParams;

        public RequestImpl() {
        }

        public RequestImpl(Request prototype) {
            if (prototype != null) {
                this.type = prototype.getType();
                this.url = prototype.getUrl();
                this.headers = new Headers(prototype.getHeaders());
                this.cookies = new ArrayList<Cookie>(prototype.getCookies());
                this.byteData = prototype.getByteData();
                this.stringData = prototype.getStringData();
                this.streamData = prototype.getStreamData();
                this.entityWriter = prototype.getEntityWriter();
                this.params = prototype.getParams() == null ? null : LinkedListMultimap.create(prototype.getParams());
                this.queryParams = prototype.getQueryParams() == null ? null : LinkedListMultimap.create(prototype.getQueryParams());
                this.parts = prototype.getParts() == null ? null : new ArrayList<Part>(prototype.getParts());
                this.virtualHost = prototype.getVirtualHost();
                this.length = prototype.getLength();
            }
        }

        @Override
        public RequestType getType() {
            return this.type;
        }

        @Override
        public String getUrl() {
            try {
                Url url = Url.valueOf(this.url);
                if (this.queryParams != null) {
                    for (Map.Entry<String, String> entry : this.queryParams.entries()) {
                        url.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                return url.toString();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Illegal URL", e);
            }
        }

        @Override
        public Headers getHeaders() {
            return Headers.unmodifiableHeaders(this.headers);
        }

        @Override
        public Collection<Cookie> getCookies() {
            return Collections.unmodifiableCollection(this.cookies);
        }

        @Override
        public byte[] getByteData() {
            return this.byteData;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public InputStream getStreamData() {
            return this.streamData;
        }

        @Override
        public Request.EntityWriter getEntityWriter() {
            return this.entityWriter;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public Multimap<String, String> getParams() {
            return this.params == null ? null : Multimaps.unmodifiableMultimap(this.params);
        }

        @Override
        public List<Part> getParts() {
            return this.parts == null ? null : Collections.unmodifiableList(this.parts);
        }

        @Override
        public String getVirtualHost() {
            return this.virtualHost;
        }

        @Override
        public Multimap<String, String> getQueryParams() {
            return this.queryParams == null ? null : Multimaps.unmodifiableMultimap(this.queryParams);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.url);
            sb.append("\t");
            sb.append((Object)this.type);
            for (String name : this.headers.getHeaderNames()) {
                sb.append("\t");
                sb.append(name);
                sb.append(":");
                sb.append(this.headers.getHeaderValue(name));
            }
            return sb.toString();
        }

        static /* synthetic */ byte[] access$602(RequestImpl x0, byte[] x1) {
            x0.byteData = x1;
            return x1;
        }
    }
}

