/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers;

import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Headers;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.url.Url;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseHeaders
extends HttpResponseHeaders {
    private final HttpChunkTrailer trailingHeaders;
    private final HttpResponse response;
    private final Headers headers;

    public ResponseHeaders(Url url, HttpResponse response, AsyncHttpProvider<HttpResponse> provider) {
        super(url, provider, false);
        this.trailingHeaders = null;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    public ResponseHeaders(Url url, HttpResponse response, AsyncHttpProvider<HttpResponse> provider, HttpChunkTrailer traillingHeaders) {
        super(url, provider, true);
        this.trailingHeaders = traillingHeaders;
        this.response = response;
        this.headers = this.computerHeaders();
    }

    private Headers computerHeaders() {
        Headers h = new Headers();
        for (String s : this.response.getHeaderNames()) {
            for (String header : this.response.getHeaders(s)) {
                h.add(s, header);
            }
        }
        if (this.trailingHeaders != null && this.trailingHeaders.getHeaderNames().size() > 0) {
            for (String s : this.trailingHeaders.getHeaderNames()) {
                for (String header : this.response.getHeaders(s)) {
                    h.add(s, header);
                }
            }
        }
        return Headers.unmodifiableHeaders(h);
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }
}

