/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import com.ning.http.multipart.MultipartEncodingUtil;
import com.ning.http.multipart.Part;
import com.ning.http.multipart.RequestEntity;
import com.ning.http.shaded.com.google.collections.collect.ArrayListMultimap;
import com.ning.http.shaded.com.google.collections.collect.Multimap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequestEntity
implements RequestEntity {
    private static final Logger log = LogManager.getLogger(MultipartRequestEntity.class);
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static byte[] MULTIPART_CHARS = MultipartEncodingUtil.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    protected Part[] parts;
    private byte[] multipartBoundary;
    private Multimap<String, String> methodParams;

    private static byte[] generateMultipartBoundary() {
        Random rand = new Random();
        byte[] bytes = new byte[rand.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    public MultipartRequestEntity(Part[] parts, Multimap<String, String> methodParams) {
        if (parts == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        if (methodParams == null) {
            methodParams = ArrayListMultimap.create();
        }
        this.parts = parts;
        this.methodParams = methodParams;
    }

    protected byte[] getMultipartBoundary() {
        if (this.multipartBoundary == null) {
            String temp = this.methodParams.get("").isEmpty() ? null : this.methodParams.get("").iterator().next();
            this.multipartBoundary = temp != null ? MultipartEncodingUtil.getAsciiBytes(temp) : MultipartRequestEntity.generateMultipartBoundary();
        }
        return this.multipartBoundary;
    }

    @Override
    public boolean isRepeatable() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isRepeatable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeRequest(OutputStream out) throws IOException {
        Part.sendParts(out, this.parts, this.getMultipartBoundary());
    }

    @Override
    public long getContentLength() {
        try {
            return Part.getLengthOfParts(this.parts, this.getMultipartBoundary());
        }
        catch (Exception e) {
            log.error((Object)"An exception occurred while getting the length of the parts", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public String getContentType() {
        StringBuffer buffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
        buffer.append("; boundary=");
        buffer.append(MultipartEncodingUtil.getAsciiString(this.getMultipartBoundary()));
        return buffer.toString();
    }
}

