/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.shaded.com.google.collections.collect;

import com.google.common.annotations.GwtCompatible;
import com.ning.http.shaded.com.google.collections.collect.AbstractMapBasedMultiset;
import com.ning.http.shaded.com.google.collections.collect.Iterables;
import com.ning.http.shaded.com.google.collections.collect.Maps;
import com.ning.http.shaded.com.google.collections.collect.Multisets;
import com.ning.http.shaded.com.google.collections.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    private static final long serialVersionUID = 0L;

    public static <E> LinkedHashMultiset<E> create() {
        return new LinkedHashMultiset<E>();
    }

    public static <E> LinkedHashMultiset<E> create(int distinctElements) {
        return new LinkedHashMultiset<E>(distinctElements);
    }

    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> elements) {
        LinkedHashMultiset<E> multiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private LinkedHashMultiset() {
        super(new LinkedHashMap());
    }

    private LinkedHashMultiset(int distinctElements) {
        super(new LinkedHashMap(Maps.capacity(distinctElements)));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(new LinkedHashMap(Maps.capacity(distinctElements)));
        Serialization.populateMultiset(this, stream, distinctElements);
    }
}

