/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.url;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Url
implements Serializable {
    private static final long serialVersionUID = 2187287725357847401L;
    private String scheme;
    private String host;
    private int port;
    private String path;
    private Map<String, List<String>> params = new LinkedHashMap<String, List<String>>();

    public static Url valueOf(String value) throws MalformedURLException {
        URL url = new URL(value);
        try {
            return new Url(url.getProtocol(), url.getHost(), url.getPort() > 0 ? url.getPort() : Protocol.valueOf(url.getProtocol().toUpperCase()).getPort(), URLDecoder.decode(url.getPath(), "UTF-8"), url.getQuery());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Url valueOf(String scheme, String host, String uri) {
        try {
            return Url.valueOf(scheme + "://" + host + uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Url valueOf(Url base, String uri) throws MalformedURLException {
        Url result;
        if (!uri.matches("[\\p{Alpha}][\\p{Alnum}-.+_]+://.+")) {
            result = new Url(base.scheme, base.host, base.port, base.path, base.params);
            if (uri.startsWith("/")) {
                result.setUri(uri);
            } else {
                String path = base.getPath();
                int index = path.lastIndexOf(47);
                path = index != -1 ? path.substring(0, index + 1) + uri : "/" + uri;
                result.setUri(path);
            }
        } else {
            result = Url.valueOf(uri);
        }
        return result;
    }

    private Url(String scheme, String host, int port, String path, Map<String, List<String>> params) {
        this.setScheme(scheme);
        this.setHost(host);
        this.port = port;
        this.path = path;
        this.params = new LinkedHashMap<String, List<String>>(params);
    }

    public Url(String scheme, String host, int port, String path, String query) {
        this.setScheme(scheme);
        this.setHost(host);
        this.port = port;
        this.path = path;
        this.setQueryString(query);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String s) {
        Protocol.valueOf(s.toUpperCase());
        this.scheme = s;
    }

    public Protocol getProtocol() {
        return Protocol.valueOf(this.scheme.toUpperCase());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host.toLowerCase();
    }

    public void setBaseUrl(String url) {
        Pattern pattern = Pattern.compile("([^:]+)://([^:]+)(:([0-9]+))?");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid url: " + url);
        }
        this.setScheme(matcher.group(1));
        this.setHost(matcher.group(2));
        String port = matcher.group(4);
        if (port != null) {
            this.port = Integer.valueOf(port);
        } else {
            Protocol protocol = this.getProtocol();
            this.port = protocol.getPort();
        }
    }

    public String getBaseUrl() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.scheme);
        builder.append("://");
        builder.append(this.getLocation());
        return builder.toString();
    }

    public String getLocation() {
        int defaultPort;
        StringBuilder builder = new StringBuilder(this.host);
        try {
            Protocol protocol = this.getProtocol();
            defaultPort = protocol.getPort();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to fetch protocol", e);
        }
        if (this.port != defaultPort) {
            builder.append(':');
            builder.append(this.port);
        }
        return builder.toString();
    }

    public void setUri(String uri) {
        int index = uri.indexOf(63);
        if (index != -1) {
            this.path = uri.substring(0, index);
            String query = uri.substring(index + 1);
            this.setQueryString(query);
        } else {
            this.path = uri;
            this.params.clear();
        }
    }

    public String getUri() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.path);
        if (!this.params.isEmpty()) {
            builder.append('?');
            builder.append(this.getQueryString());
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getBaseUrl());
        builder.append(this.getUri());
        return builder.toString();
    }

    public String toStringWithoutParams() {
        return new Url(this.scheme, this.host, this.port, this.path, "").toString();
    }

    private void parseParameters(String query) {
        this.params.clear();
        if (query != null) {
            StringTokenizer tokenizer = new StringTokenizer(query, "&");
            while (tokenizer.hasMoreElements()) {
                String value;
                String token = tokenizer.nextToken();
                String[] param = token.split("=", 2);
                if (param.length <= 0) continue;
                String name = param[0];
                String string = value = param.length > 1 ? this.urlDecode(param[1]) : null;
                if (name.length() <= 0) continue;
                this.addParameter(name, value);
            }
        }
    }

    private String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Should never happen: UTF-8 encoding is unsupported.", e);
        }
    }

    public void setParameter(String name, String value) {
        this.removeParameter(name);
        this.addParameter(name, value);
    }

    public void clearParameters() {
        this.params.clear();
    }

    public void setParameter(String name, Object value) {
        this.setParameter(name, value.toString());
    }

    public void addParameter(String name, String value) {
        List<String> list = this.params.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.params.put(name, list);
        }
        list.add(value);
    }

    public String getParameter(String name) {
        String result = null;
        List<String> list = this.params.get(name);
        if (list != null && list.size() > 0) {
            result = list.get(0);
        }
        return result;
    }

    public List<String> getParameters(String name) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> list = this.params.get(name);
        if (list != null && list.size() > 0) {
            result.addAll(list);
        }
        return result;
    }

    public Map<String, List<String>> getParameters() {
        return this.params;
    }

    public void removeParameter(String name) {
        this.params.remove(name);
    }

    public void setQueryString(String query) {
        this.parseParameters(query);
    }

    public String getQueryString() {
        String result = null;
        if (!this.params.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<Map.Entry<String, List<String>>> i = this.params.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, List<String>> param = i.next();
                String name = param.getKey();
                Iterator<String> j = param.getValue().iterator();
                while (j.hasNext()) {
                    String value = j.next();
                    builder.append(name);
                    if (value != null) {
                        builder.append('=');
                        try {
                            builder.append(URLEncoder.encode(value, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    if (!j.hasNext()) continue;
                    builder.append('&');
                }
                if (!i.hasNext()) continue;
                builder.append('&');
            }
            result = builder.toString();
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Url && this.toString().equals(obj.toString());
    }

    public static boolean isValidUrl(String url) {
        try {
            Url.valueOf(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        HTTP(80),
        HTTPS(443);

        private int port;

        private Protocol(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }
    }
}

