/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FutureImpl;
import com.ning.http.client.Request;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NettyResponseFuture<V>
implements FutureImpl<V> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AsyncHandler<V> asyncHandler;
    private final int responseTimeoutInMs;
    private final Request request;
    private final HttpRequest nettyRequest;
    private final AtomicReference<V> content = new AtomicReference();
    private URI uri;
    private boolean keepAlive = true;
    private HttpResponse httpResponse;
    private final AtomicReference<ExecutionException> exEx = new AtomicReference();
    private final AtomicInteger redirectCount = new AtomicInteger();
    private Future<Object> reaperFuture;
    private boolean inDigestAuth;

    public NettyResponseFuture(URI uri, Request request, AsyncHandler<V> asyncHandler, HttpRequest nettyRequest, int responseTimeoutInMs) {
        this.asyncHandler = asyncHandler;
        this.responseTimeoutInMs = responseTimeoutInMs;
        this.request = request;
        this.nettyRequest = nettyRequest;
        this.uri = uri;
    }

    public URI getURI() throws MalformedURLException {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    @Override
    public boolean isDone() {
        return this.isDone.get();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    @Override
    public boolean cancel(boolean force) {
        this.latch.countDown();
        this.isCancelled.set(true);
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.responseTimeoutInMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long l, TimeUnit tu) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.isDone() && !this.isCancelled()) {
            if (!this.latch.await(l, tu)) {
                this.isCancelled.set(true);
                TimeoutException te = new TimeoutException("No response received");
                try {
                    this.asyncHandler.onThrowable(te);
                }
                finally {
                    throw te;
                }
            }
            this.isDone.set(true);
            ExecutionException e = this.exEx.getAndSet(null);
            if (e != null) {
                throw e;
            }
        }
        return this.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V getContent() {
        V update;
        try {
            update = this.asyncHandler.onCompleted();
        }
        catch (Throwable ex) {
            try {
                this.asyncHandler.onThrowable(ex);
            }
            finally {
                throw new RuntimeException(ex);
            }
        }
        this.content.compareAndSet(null, update);
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void done() {
        try {
            if (this.exEx.get() != null) {
                return;
            }
            if (this.reaperFuture != null) {
                this.reaperFuture.cancel(true);
            }
            this.isDone.set(true);
            this.getContent();
        }
        finally {
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void abort(Throwable t) {
        if (this.isDone.get() || this.isCancelled.get()) {
            return;
        }
        if (this.reaperFuture != null) {
            this.reaperFuture.cancel(true);
        }
        this.exEx.compareAndSet(null, new ExecutionException(t));
        try {
            this.asyncHandler.onThrowable(t);
        }
        finally {
            this.isDone.set(true);
            this.latch.countDown();
        }
    }

    public final Request getRequest() {
        return this.request;
    }

    public final HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    public final AsyncHandler<V> getAsyncHandler() {
        return this.asyncHandler;
    }

    public final boolean getKeepAlive() {
        return this.keepAlive;
    }

    public final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public final HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public final void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public int incrementAndGetCurrentRedirectCount() {
        return this.redirectCount.incrementAndGet();
    }

    public void setReaperFuture(Future<Object> reaperFuture) {
        this.reaperFuture = reaperFuture;
    }

    public boolean isInDigestAuth() {
        return this.inDigestAuth;
    }

    public void setInDigestAuth(boolean inDigestAuth) {
        this.inDigestAuth = inDigestAuth;
    }
}

