/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.Realm;
import com.ning.http.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public final class AuthenticatorUtils {
    public static String computeBasicAuthentication(Realm realm) {
        String s = realm.getPrincipal() + ":" + realm.getPassword();
        return "Basic " + Base64.encode(s.getBytes());
    }

    public static String computeDigestAuthentication(Realm realm) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.construct(builder, "username", realm.getPrincipal());
        AuthenticatorUtils.construct(builder, "realm", realm.getRealmName());
        AuthenticatorUtils.construct(builder, "nonce", realm.getNonce());
        AuthenticatorUtils.construct(builder, "uri", realm.getUri());
        builder.append("algorithm").append('=').append(realm.getAlgorithm()).append(", ");
        AuthenticatorUtils.construct(builder, "response", realm.getResponse());
        builder.append("qop").append('=').append(realm.getQop()).append(", ");
        builder.append("nc").append('=').append(realm.getNc()).append(", ");
        AuthenticatorUtils.construct(builder, "cnonce", realm.getCnonce(), true);
        return new String(builder.toString().getBytes("ISO_8859_1"));
    }

    private static StringBuilder construct(StringBuilder builder, String name, String value) {
        return AuthenticatorUtils.construct(builder, name, value, false);
    }

    private static StringBuilder construct(StringBuilder builder, String name, String value, boolean tail) {
        return builder.append(name).append('=').append('\"').append(value).append(tail ? "\"" : "\", ");
    }
}

