/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConnectListener<T>
implements ChannelFutureListener {
    private final AsyncHttpClientConfig config;
    private final NettyResponseFuture<T> future;
    private final HttpRequest nettyRequest;

    private ConnectListener(AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
        this.config = config;
        this.future = future;
        this.nettyRequest = nettyRequest;
    }

    public NettyResponseFuture<T> future() {
        return this.future;
    }

    public final void operationComplete(ChannelFuture f) throws Exception {
        try {
            this.future.provider().executeRequest(f.getChannel(), this.config, this.future, this.nettyRequest);
        }
        catch (ConnectException ex) {
            this.future.abort(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final Logger log = LogManager.getLogger(Builder.class);
        private final AsyncHttpClientConfig config;
        private final Request request;
        private final AsyncHandler<T> asyncHandler;
        private NettyResponseFuture<T> future;
        private final NettyAsyncHttpProvider provider;

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyAsyncHttpProvider provider) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = null;
            this.provider = provider;
        }

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, NettyAsyncHttpProvider provider) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = future;
            this.provider = provider;
        }

        public ConnectListener<T> build() throws IOException {
            URI uri = AsyncHttpProviderUtils.createUri(this.request.getRawUrl().replace(" ", "%20"));
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, this.request, uri, true);
            if (this.future == null) {
                this.future = new NettyResponseFuture<T>(uri, this.request, this.asyncHandler, nettyRequest, NettyAsyncHttpProvider.requestTimeout(this.config, this.request.getPerRequestConfig()), this.provider);
            }
            return new ConnectListener(this.config, this.future, nettyRequest);
        }
    }
}

