/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.jdk;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FutureImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKFuture<V>
implements FutureImpl<V> {
    private Future<V> innerFuture;
    private final AsyncHandler<V> asyncHandler;
    private final int responseTimeoutInMs;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean timedOut = new AtomicBoolean(false);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicReference<Throwable> exception = new AtomicReference();
    private final AtomicLong touch = new AtomicLong(System.currentTimeMillis());
    private final AtomicBoolean contentProcessed = new AtomicBoolean(false);

    public JDKFuture(AsyncHandler<V> asyncHandler, int responseTimeoutInMs) {
        this.asyncHandler = asyncHandler;
        this.responseTimeoutInMs = responseTimeoutInMs;
    }

    protected void setInnerFuture(Future<V> innerFuture) {
        this.innerFuture = innerFuture;
    }

    @Override
    public void done(Callable callable) {
        this.isDone.set(true);
    }

    @Override
    public void abort(Throwable t) {
        this.innerFuture.cancel(true);
        this.exception.set(t);
        if (!this.timedOut.get() && !this.cancelled.get()) {
            this.asyncHandler.onThrowable(t);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled.set(true);
        return this.innerFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.innerFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        this.contentProcessed.set(true);
        return this.innerFuture.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.responseTimeoutInMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        V content = null;
        try {
            content = this.innerFuture.get(timeout, unit);
        }
        catch (TimeoutException t) {
            if (!this.contentProcessed.get() && timeout != -1L && System.currentTimeMillis() - this.touch.get() <= (long)this.responseTimeoutInMs) {
                return this.get(timeout, unit);
            }
            this.timedOut.set(true);
            throw new TimeoutException(String.format("No response received after %s", this.responseTimeoutInMs));
        }
        catch (CancellationException ce) {
            // empty catch block
        }
        if (this.exception.get() != null) {
            throw new ExecutionException(this.exception.get());
        }
        return content;
    }

    public boolean hasExpired() {
        return this.responseTimeoutInMs != -1 && System.currentTimeMillis() - this.touch.get() > (long)this.responseTimeoutInMs;
    }

    protected void touch() {
        this.touch.set(System.currentTimeMillis());
    }
}

