/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnectionsPool
implements ConnectionsPool<String, Channel> {
    private static final Logger log = LogManager.getLogger(NettyAsyncHttpProvider.class);
    private final ConcurrentHashMap<String, List<Channel>> connectionsPool = new ConcurrentHashMap();
    private final AtomicInteger totalConnections = new AtomicInteger(0);
    private final AsyncHttpClientConfig config;

    public NettyConnectionsPool(AsyncHttpClientConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConnection(String uri, Channel connection) {
        if (log.isDebugEnabled()) {
            log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Adding uri: %s for channel %s", uri, connection), new Object[0]);
        }
        connection.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment((Object)new NettyAsyncHttpProvider.DiscardEvent());
        List<Channel> pooledConnectionForHost = this.connectionsPool.get(uri);
        if (pooledConnectionForHost == null) {
            LinkedList newPool = new LinkedList();
            this.connectionsPool.putIfAbsent(uri, newPool);
            pooledConnectionForHost = this.connectionsPool.get(uri);
        }
        List<Channel> list = pooledConnectionForHost;
        synchronized (list) {
            int size = pooledConnectionForHost.size();
            if (this.config.getMaxConnectionPerHost() == -1 || size < this.config.getMaxConnectionPerHost()) {
                boolean added = pooledConnectionForHost.add(connection);
                if (added) {
                    this.totalConnections.incrementAndGet();
                }
                return added;
            }
            log.warn("Maximum connections per hosts reached " + this.config.getMaxConnectionPerHost(), new Object[0]);
            return false;
        }
    }

    @Override
    public Channel getConnection(String uri) {
        return this.removeConnection(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel removeConnection(String uri) {
        Channel channel = null;
        List<Channel> pooledConnectionForHost = this.connectionsPool.get(uri);
        if (pooledConnectionForHost != null) {
            boolean poolEmpty = false;
            while (!poolEmpty && channel == null) {
                List<Channel> list = pooledConnectionForHost;
                synchronized (list) {
                    if (pooledConnectionForHost.size() > 0) {
                        channel = pooledConnectionForHost.remove(0);
                    }
                }
                if (channel == null) {
                    poolEmpty = true;
                    continue;
                }
                if (!channel.isConnected() || !channel.isOpen()) {
                    this.removeAllConnections(channel);
                    channel = null;
                    continue;
                }
                this.totalConnections.decrementAndGet();
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllConnections(Channel connection) {
        boolean isRemoved = false;
        for (Map.Entry<String, List<Channel>> e : this.connectionsPool.entrySet()) {
            List<Channel> list = e.getValue();
            synchronized (list) {
                boolean removed = e.getValue().remove(connection);
                if (removed) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format(NettyAsyncHttpProvider.currentThread() + "Removing uri: %s for channel %s", e.getKey(), e.getValue()), new Object[0]);
                    }
                    this.totalConnections.decrementAndGet();
                }
                isRemoved |= removed;
            }
        }
        return isRemoved;
    }

    @Override
    public boolean canCacheConnection() {
        return this.config.getMaxTotalConnections() == -1 || this.totalConnections.get() < this.config.getMaxTotalConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() {
        try {
            Iterator<Map.Entry<String, List<Channel>>> i = this.connectionsPool.entrySet().iterator();
            while (i.hasNext()) {
                List<Channel> list;
                List<Channel> list2 = list = i.next().getValue();
                synchronized (list2) {
                    for (int j = 0; j < list.size(); ++j) {
                        Channel channel = list.remove(0);
                        this.removeAllConnections(channel);
                        channel.close();
                    }
                }
            }
            return;
        }
        finally {
            this.connectionsPool.clear();
        }
    }
}

