/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.apache;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.Body;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.Cookie;
import com.ning.http.client.FilePart;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.Part;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.StringPart;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.apache.ApacheAsyncHttpProviderConfig;
import com.ning.http.client.providers.apache.ApacheResponse;
import com.ning.http.client.providers.apache.ApacheResponseBodyPart;
import com.ning.http.client.providers.apache.ApacheResponseFuture;
import com.ning.http.client.providers.apache.ApacheResponseHeaders;
import com.ning.http.client.providers.apache.ApacheResponseStatus;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProvider;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProviderConfig;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.CircularRedirectException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheAsyncHttpProvider
implements AsyncHttpProvider<HttpClient> {
    private static final Logger logger = LogManager.getLogger(JDKAsyncHttpProvider.class);
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private IdleConnectionTimeoutThread idleConnectionTimeoutThread;
    private final AtomicInteger maxConnections = new AtomicInteger();
    private final MultiThreadedHttpConnectionManager connectionManager;
    private final HttpClientParams params;

    public ApacheAsyncHttpProvider(AsyncHttpClientConfig config) throws IOException {
        this.config = config;
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.params = new HttpClientParams();
        this.params.setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        this.params.setCookiePolicy("compatibility");
        this.params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        AsyncHttpProviderConfig<?, ?> providerConfig = config.getAsyncHttpProviderConfig();
        if (providerConfig != null && JDKAsyncHttpProviderConfig.class.isAssignableFrom(providerConfig.getClass())) {
            this.configure((ApacheAsyncHttpProviderConfig)ApacheAsyncHttpProviderConfig.class.cast(providerConfig));
        }
    }

    private void configure(ApacheAsyncHttpProviderConfig config) {
    }

    @Override
    public <T> Future<T> execute(Request request, AsyncHandler<T> handler) throws IOException {
        Realm realm;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (this.config.getMaxTotalConnections() > -1 && this.maxConnections.get() + 1 > this.config.getMaxTotalConnections()) {
            throw new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
        }
        if (this.idleConnectionTimeoutThread != null) {
            this.idleConnectionTimeoutThread.shutdown();
            this.idleConnectionTimeoutThread = null;
        }
        int requestTimeout = ApacheAsyncHttpProvider.requestTimeout(this.config, request.getPerRequestConfig());
        if (this.config.getIdleConnectionTimeoutInMs() > 0 && requestTimeout != -1 && requestTimeout < this.config.getIdleConnectionTimeoutInMs()) {
            this.idleConnectionTimeoutThread = new IdleConnectionTimeoutThread();
            this.idleConnectionTimeoutThread.setConnectionTimeout((long)this.config.getIdleConnectionTimeoutInMs());
            this.idleConnectionTimeoutThread.addConnectionManager((HttpConnectionManager)this.connectionManager);
            this.idleConnectionTimeoutThread.start();
        }
        HttpClient httpClient = new HttpClient(this.params, (HttpConnectionManager)this.connectionManager);
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        if (realm != null) {
            httpClient.getParams().setAuthenticationPreemptive(realm.getUsePreemptiveAuth());
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(realm.getPrincipal(), realm.getPassword());
            httpClient.getState().setCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)defaultcreds);
        }
        HttpMethodBase method = this.createMethod(httpClient, request);
        ApacheResponseFuture<T> f = new ApacheResponseFuture<T>(handler, requestTimeout, request, method);
        f.touch();
        f.setInnerFuture(this.config.executorService().submit(new ApacheClientRunnable<T>(request, handler, method, f, httpClient)));
        this.maxConnections.incrementAndGet();
        return f;
    }

    @Override
    public void close() {
        if (this.idleConnectionTimeoutThread != null) {
            this.idleConnectionTimeoutThread.shutdown();
            this.idleConnectionTimeoutThread = null;
        }
        if (this.connectionManager != null) {
            try {
                this.connectionManager.shutdown();
            }
            catch (Exception e) {
                logger.error("Error shutting down connection manager", e);
            }
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new ApacheResponse(status, headers, bodyParts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpMethodBase createMethod(HttpClient client, Request request) throws IOException, FileNotFoundException {
        ProxyServer proxyServer;
        DeleteMethod method;
        block50: {
            String methodName;
            block42: {
                PostMethod post;
                block44: {
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        block43: {
                                            methodName = request.getReqType();
                                            method = null;
                                            if (!methodName.equalsIgnoreCase("POST") && !methodName.equalsIgnoreCase("PUT")) break block42;
                                            post = methodName.equalsIgnoreCase("POST") ? new PostMethod(request.getUrl()) : new PutMethod(request.getUrl());
                                            post.getParams().setContentCharset("UTF-8");
                                            if (request.getByteData() == null) break block43;
                                            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(request.getByteData()));
                                            post.setRequestHeader("Content-Length", String.valueOf(request.getByteData().length));
                                            break block44;
                                        }
                                        if (request.getStringData() == null) break block45;
                                        post.setRequestEntity((RequestEntity)new StringRequestEntity(request.getStringData(), "text/xml", "UTF-8"));
                                        post.setRequestHeader("Content-Length", String.valueOf(request.getStringData().length()));
                                        break block44;
                                    }
                                    if (request.getStreamData() == null) break block46;
                                    InputStreamRequestEntity r = new InputStreamRequestEntity(request.getStreamData());
                                    post.setRequestEntity((RequestEntity)r);
                                    post.setRequestHeader("Content-Length", String.valueOf(r.getContentLength()));
                                    break block44;
                                }
                                if (request.getParams() == null) break block47;
                                StringBuilder sb = new StringBuilder();
                                for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                                    String key = paramEntry.getKey();
                                    for (String value : paramEntry.getValue()) {
                                        if (sb.length() > 0) {
                                            sb.append("&");
                                        }
                                        UTF8UrlEncoder.appendEncoded(sb, key);
                                        sb.append("=");
                                        UTF8UrlEncoder.appendEncoded(sb, value);
                                    }
                                }
                                post.setRequestHeader("Content-Length", String.valueOf(sb.length()));
                                post.setRequestEntity((RequestEntity)new StringRequestEntity(sb.toString(), "text/xml", "UTF-8"));
                                if (!request.getHeaders().containsKey("Content-Type")) {
                                    post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                                }
                                break block44;
                            }
                            if (request.getParts() == null) break block48;
                            MultipartRequestEntity mre = this.createMultipartRequestEntity(request.getParts(), post.getParams());
                            post.setRequestEntity((RequestEntity)mre);
                            post.setRequestHeader("Content-Type", mre.getContentType());
                            post.setRequestHeader("Content-Length", String.valueOf(mre.getContentLength()));
                            break block44;
                        }
                        if (request.getEntityWriter() == null) break block49;
                        post.setRequestEntity((RequestEntity)new EntityWriterRequestEntity(request.getEntityWriter(), ApacheAsyncHttpProvider.computeAndSetContentLength(request, (HttpMethodBase)post)));
                        break block44;
                    }
                    if (request.getFile() != null) {
                        File file = request.getFile();
                        if (!file.isFile()) {
                            throw new IOException(String.format(Thread.currentThread() + "File %s is not a file or doesn't exist", file.getAbsolutePath()));
                        }
                        post.setRequestHeader("Content-Length", String.valueOf(file.length()));
                        FileInputStream fis = new FileInputStream(file);
                        try {
                            InputStreamRequestEntity r = new InputStreamRequestEntity((InputStream)fis);
                            post.setRequestEntity((RequestEntity)r);
                            post.setRequestHeader("Content-Length", String.valueOf(r.getContentLength()));
                        }
                        finally {
                            fis.close();
                        }
                    }
                    if (request.getBodyGenerator() != null) {
                        Body body = request.getBodyGenerator().createBody();
                        try {
                            int length = (int)body.getContentLength();
                            if (length < 0) {
                                length = (int)request.getLength();
                            }
                            if (length >= 0) {
                                post.setRequestHeader("Content-Length", String.valueOf(length));
                            }
                            byte[] bytes = new byte[length];
                            ByteBuffer buffer = ByteBuffer.wrap(bytes);
                            do {
                                buffer.clear();
                            } while (body.read(buffer) >= 0L);
                            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bytes));
                        }
                        catch (Throwable throwable) {
                            try {
                                body.close();
                            }
                            catch (IOException e) {
                                logger.warn(e, "Failed to close request body: %s", e.getMessage());
                            }
                            throw throwable;
                        }
                        try {
                            body.close();
                        }
                        catch (IOException e) {
                            logger.warn(e, "Failed to close request body: %s", e.getMessage());
                        }
                    }
                }
                method = post;
                break block50;
            }
            if (methodName.equalsIgnoreCase("DELETE")) {
                method = new DeleteMethod(request.getUrl());
            } else if (methodName.equalsIgnoreCase("HEAD")) {
                method = new HeadMethod(request.getUrl());
            } else if (methodName.equalsIgnoreCase("GET")) {
                method = new GetMethod(request.getUrl());
            } else if (methodName.equalsIgnoreCase("OPTIONS")) {
                method = new OptionsMethod(request.getUrl());
            } else {
                throw new IllegalStateException(String.format("Invalid Method", methodName));
            }
        }
        ProxyServer proxyServer2 = proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        if (proxyServer != null) {
            if (proxyServer.getPrincipal() != null) {
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(proxyServer.getPrincipal(), proxyServer.getPassword());
                client.getState().setCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)defaultcreds);
            }
            ProxyHost proxyHost = proxyServer == null ? null : new ProxyHost(proxyServer.getHost(), proxyServer.getPort());
            client.getHostConfiguration().setProxyHost(proxyHost);
        }
        method.setFollowRedirects(false);
        if (request.getCookies() != null && !request.getCookies().isEmpty()) {
            for (Cookie cookie : request.getCookies()) {
                method.setRequestHeader("Cookie", AsyncHttpProviderUtils.encodeCookies(request.getCookies()));
            }
        }
        if (request.getHeaders() != null) {
            for (String name : request.getHeaders().keySet()) {
                if ("host".equalsIgnoreCase(name)) continue;
                Iterator i$ = request.getHeaders().get(name).iterator();
                while (i$.hasNext()) {
                    String value = (String)i$.next();
                    method.setRequestHeader(name, value);
                }
            }
        }
        if (request.getHeaders().getFirstValue("User-Agent") == null && this.config.getUserAgent() != null) {
            method.setRequestHeader("User-Agent", this.config.getUserAgent());
        } else {
            method.setRequestHeader("User-Agent", AsyncHttpProviderUtils.constructUserAgent(ApacheAsyncHttpProvider.class));
        }
        if (this.config.isCompressionEnabled()) {
            Header acceptableEncodingHeader = method.getRequestHeader("Accept-Encoding");
            if (acceptableEncodingHeader != null) {
                String acceptableEncodings = acceptableEncodingHeader.getValue();
                if (acceptableEncodings.indexOf("gzip") == -1) {
                    StringBuilder buf = new StringBuilder(acceptableEncodings);
                    if (buf.length() > 1) {
                        buf.append(",");
                    }
                    buf.append("gzip");
                    method.setRequestHeader("Accept-Encoding", buf.toString());
                }
            } else {
                method.setRequestHeader("Accept-Encoding", "gzip");
            }
        }
        if (request.getVirtualHost() != null) {
            method.getParams().setVirtualHost(request.getVirtualHost());
        }
        return method;
    }

    private static final int computeAndSetContentLength(Request request, HttpMethodBase m) {
        int lenght = (int)request.getLength();
        if (lenght == -1 && m.getRequestHeader("Content-Length") != null) {
            lenght = Integer.valueOf(m.getRequestHeader("Content-Length").getValue());
        }
        if (lenght != -1) {
            m.setRequestHeader("Content-Length", String.valueOf(lenght));
        }
        return lenght;
    }

    static final String currentThread() {
        return AsyncHttpProviderUtils.currentThread();
    }

    private MultipartRequestEntity createMultipartRequestEntity(List<Part> params, HttpMethodParams methodParams) throws FileNotFoundException {
        org.apache.commons.httpclient.methods.multipart.Part[] parts = new org.apache.commons.httpclient.methods.multipart.Part[params.size()];
        int i = 0;
        for (Part part : params) {
            if (part instanceof StringPart) {
                parts[i] = new org.apache.commons.httpclient.methods.multipart.StringPart(part.getName(), ((StringPart)part).getValue(), "UTF-8");
            } else if (part instanceof FilePart) {
                parts[i] = new org.apache.commons.httpclient.methods.multipart.FilePart(part.getName(), ((FilePart)part).getFile(), ((FilePart)part).getMimeType(), ((FilePart)part).getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPartSource source = new ByteArrayPartSource(((ByteArrayPart)part).getFileName(), ((ByteArrayPart)part).getData());
                parts[i] = new org.apache.commons.httpclient.methods.multipart.FilePart(part.getName(), (PartSource)source, ((ByteArrayPart)part).getMimeType(), ((ByteArrayPart)part).getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, methodParams);
    }

    protected static int requestTimeout(AsyncHttpClientConfig config, PerRequestConfig perRequestConfig) {
        int prRequestTimeout;
        int result = perRequestConfig != null ? ((prRequestTimeout = perRequestConfig.getRequestTimeoutInMs()) != 0 ? prRequestTimeout : config.getRequestTimeoutInMs()) : config.getRequestTimeoutInMs();
        return result;
    }

    static /* synthetic */ HttpMethodBase access$300(ApacheAsyncHttpProvider x0, HttpClient x1, Request x2) throws IOException, FileNotFoundException {
        return x0.createMethod(x1, x2);
    }

    static /* synthetic */ AtomicInteger access$400(ApacheAsyncHttpProvider x0) {
        return x0.maxConnections;
    }

    static {
        final TrustingSSLSocketFactory factory = new TrustingSSLSocketFactory();
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", new ProtocolSocketFactory(){

            public Socket createSocket(String string, int i, InetAddress inetAddress, int i1) throws IOException {
                return factory.createSocket(string, i, inetAddress, i1);
            }

            public Socket createSocket(String string, int i, InetAddress inetAddress, int i1, HttpConnectionParams httpConnectionParams) throws IOException {
                return factory.createSocket(string, i, inetAddress, i1);
            }

            public Socket createSocket(String string, int i) throws IOException {
                return factory.createSocket(string, i);
            }
        }, 443));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReaperFuture
    implements Future,
    Runnable {
        private Future scheduledFuture;
        private ApacheResponseFuture<?> apacheResponseFuture;

        public ReaperFuture(ApacheResponseFuture<?> apacheResponseFuture) {
            this.apacheResponseFuture = apacheResponseFuture;
        }

        public void setScheduledFuture(Future scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            this.apacheResponseFuture = null;
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.scheduledFuture.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.scheduledFuture.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        @Override
        public synchronized void run() {
            if (this.apacheResponseFuture != null && this.apacheResponseFuture.hasExpired()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(ApacheAsyncHttpProvider.currentThread() + "Request Timeout expired for " + this.apacheResponseFuture, new Object[0]);
                }
                int requestTimeout = ApacheAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                PerRequestConfig p = this.apacheResponseFuture.getRequest().getPerRequestConfig();
                if (p != null && p.getRequestTimeoutInMs() != -1) {
                    requestTimeout = p.getRequestTimeoutInMs();
                }
                this.apacheResponseFuture.abort(new TimeoutException(String.format("No response received after %s", requestTimeout)));
                this.apacheResponseFuture = null;
            }
        }
    }

    private static class TrustEveryoneTrustManager
    implements X509TrustManager {
        private TrustEveryoneTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class TrustingSSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory delegate;

        private TrustingSSLSocketFactory() {
            try {
                SSLContext sslcontext = SSLContext.getInstance("SSL");
                sslcontext.init(null, new TrustManager[]{new TrustEveryoneTrustManager()}, new SecureRandom());
                this.delegate = sslcontext.getSocketFactory();
            }
            catch (KeyManagementException e) {
                throw new IllegalStateException();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException();
            }
        }

        public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
            return this.delegate.createSocket(s, i);
        }

        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
            return this.delegate.createSocket(s, i, inetAddress, i1);
        }

        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.delegate.createSocket(inetAddress, i);
        }

        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.delegate.createSocket(inetAddress, i, inetAddress1, i1);
        }

        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            return this.delegate.createSocket(socket, s, i, b);
        }
    }

    public class EntityWriterRequestEntity
    implements RequestEntity {
        private Request.EntityWriter entityWriter;
        private long contentLength;

        public EntityWriterRequestEntity(Request.EntityWriter entityWriter, long contentLength) {
            this.entityWriter = entityWriter;
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getContentType() {
            return null;
        }

        public boolean isRepeatable() {
            return false;
        }

        public void writeRequest(OutputStream out) throws IOException {
            this.entityWriter.writeEntity(out);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ApacheClientRunnable<T>
    implements Callable<T> {
        private final AsyncHandler<T> asyncHandler;
        private HttpMethodBase method;
        private final ApacheResponseFuture<T> future;
        private Request request;
        private final HttpClient httpClient;
        private int currentRedirectCount;
        private AtomicBoolean isAuth = new AtomicBoolean(false);
        private byte[] cachedBytes;
        private int cachedBytesLenght;

        public ApacheClientRunnable(Request request, AsyncHandler<T> asyncHandler, HttpMethodBase method, ApacheResponseFuture<T> future, HttpClient httpClient) {
            this.asyncHandler = asyncHandler;
            this.method = method;
            this.future = future;
            this.request = request;
            this.httpClient = httpClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public T call() {
            block32: {
                block34: {
                    block30: {
                        block31: {
                            state = AsyncHandler.STATE.ABORT;
                            uri = null;
                            try {
                                uri = AsyncHttpProviderUtils.createUri(this.request.getRawUrl());
                            }
                            catch (IllegalArgumentException u) {
                                uri = AsyncHttpProviderUtils.createUri(this.request.getUrl());
                            }
                            delay = ApacheAsyncHttpProvider.requestTimeout(ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this), this.future.getRequest().getPerRequestConfig());
                            if (delay != -1) {
                                reaperFuture = new ReaperFuture(this.future);
                                scheduledFuture = ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).reaper().scheduleAtFixedRate(reaperFuture, delay, 500L, TimeUnit.MILLISECONDS);
                                reaperFuture.setScheduledFuture(scheduledFuture);
                                this.future.setReaperFuture(reaperFuture);
                            }
                            statusCode = 200;
                            try {
                                statusCode = this.httpClient.executeMethod((HttpMethod)this.method);
                            }
                            catch (CircularRedirectException ex) {
                                statusCode = 302;
                                this.currentRedirectCount = ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxRedirects();
                            }
                            if (ApacheAsyncHttpProvider.access$200().isDebugEnabled()) {
                                ApacheAsyncHttpProvider.access$200().debug(String.format(ApacheAsyncHttpProvider.currentThread() + "\n\nRequest %s\n\nResponse %s\n", new Object[]{this.request.toString(), this.method.toString()}), new Object[0]);
                            }
                            v0 = redirectEnabled = this.request.isRedirectEnabled() != false || ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).isRedirectEnabled() != false;
                            if (!redirectEnabled || statusCode != 302 && statusCode != 301) ** GOTO lbl51
                            this.isAuth.set(false);
                            if (this.currentRedirectCount++ >= ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxRedirects()) ** GOTO lbl50
                            location = this.method.getResponseHeader("Location").getValue();
                            if (location.startsWith("/")) {
                                location = AsyncHttpProviderUtils.getBaseUrl(uri) + location;
                            }
                            if (location.equals(uri.toString())) break block30;
                            newUri = AsyncHttpProviderUtils.createUri(location);
                            builder = new RequestBuilder(this.request);
                            newUrl = newUri.toString();
                            if (ApacheAsyncHttpProvider.access$200().isDebugEnabled()) {
                                ApacheAsyncHttpProvider.access$200().debug(String.format(AsyncHttpProviderUtils.currentThread() + "Redirecting to %s", new Object[]{newUrl}), new Object[0]);
                            }
                            this.request = builder.setUrl(newUrl).build();
                            this.method = ApacheAsyncHttpProvider.access$300(ApacheAsyncHttpProvider.this, this.httpClient, this.request);
                            var10_22 = this.call();
                            if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block31;
                            ApacheAsyncHttpProvider.access$400(ApacheAsyncHttpProvider.this).decrementAndGet();
                        }
                        this.future.done(null);
                        this.method.releaseConnection();
                        return var10_22;
                    }
                    break block34;
lbl50:
                    // 1 sources

                    throw new MaxRedirectException("Maximum redirect reached: " + ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxRedirects());
                }
                if ((state = this.asyncHandler.onStatusReceived(new ApacheResponseStatus(uri, this.method, ApacheAsyncHttpProvider.this))) == AsyncHandler.STATE.CONTINUE) {
                    state = this.asyncHandler.onHeadersReceived(new ApacheResponseHeaders(uri, this.method, ApacheAsyncHttpProvider.this));
                }
                if (state == AsyncHandler.STATE.CONTINUE && (is /* !! */  = this.method.getResponseBodyAsStream()) != null) {
                    h = this.method.getResponseHeader("Content-Encoding");
                    if (h != null) {
                        contentEncoding = h.getValue();
                        v1 = isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding);
                        if (isGZipped) {
                            is /* !! */  = new GZIPInputStream(is /* !! */ );
                        }
                    }
                    lengthWrapper = new int[1];
                    bytes = AsyncHttpProviderUtils.readFully(is /* !! */ , lengthWrapper);
                    if (lengthWrapper[0] > 0) {
                        body = new byte[lengthWrapper[0]];
                        System.arraycopy(bytes, 0, body, 0, lengthWrapper[0]);
                        this.future.touch();
                        this.asyncHandler.onBodyPartReceived(new ApacheResponseBodyPart(uri, body, ApacheAsyncHttpProvider.this));
                    }
                }
                if (ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
                is /* !! */  = this.asyncHandler.onCompleted();
                if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxTotalConnections() == -1) break block32;
                ApacheAsyncHttpProvider.access$400(ApacheAsyncHttpProvider.this).decrementAndGet();
            }
            this.future.done(null);
            this.method.releaseConnection();
            return (T)is /* !! */ ;
            {
                catch (Throwable t) {
                    try {
                        ex = new RuntimeException();
                        ex.initCause(t);
                        throw ex;
                    }
                    catch (Throwable t) {
                        if (this.method.isAborted()) {
                            delay = null;
                            if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxTotalConnections() != -1) {
                                ApacheAsyncHttpProvider.access$400(ApacheAsyncHttpProvider.this).decrementAndGet();
                            }
                            this.future.done(null);
                            this.method.releaseConnection();
                            return delay;
                        }
                        try {
                            if (ApacheAsyncHttpProvider.access$200().isDebugEnabled()) {
                                ApacheAsyncHttpProvider.access$200().debug(t);
                            }
                            try {
                                this.future.abort(this.filterException(t));
                            }
                            catch (Throwable t2) {
                                ApacheAsyncHttpProvider.access$200().error(t2);
                            }
                        }
                        catch (Throwable var11_24) {
                            throw var11_24;
                        }
                        finally {
                            if (ApacheAsyncHttpProvider.access$100(ApacheAsyncHttpProvider.this).getMaxTotalConnections() != -1) {
                                ApacheAsyncHttpProvider.access$400(ApacheAsyncHttpProvider.this).decrementAndGet();
                            }
                            this.future.done(null);
                            this.method.releaseConnection();
                        }
                    }
                }
            }
            return null;
        }

        private Throwable filterException(Throwable t) {
            if (UnknownHostException.class.isAssignableFrom(t.getClass())) {
                t = new ConnectException(t.getMessage());
            }
            if (NoHttpResponseException.class.isAssignableFrom(t.getClass())) {
                int responseTimeoutInMs = ApacheAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                if (this.request.getPerRequestConfig() != null && this.request.getPerRequestConfig().getRequestTimeoutInMs() != -1) {
                    responseTimeoutInMs = this.request.getPerRequestConfig().getRequestTimeoutInMs();
                }
                t = new TimeoutException(String.format("No response received after %s", responseTimeoutInMs));
            }
            if (SSLHandshakeException.class.isAssignableFrom(t.getClass())) {
                ConnectException t2 = new ConnectException();
                t2.initCause(t);
                t = t2;
            }
            return t;
        }
    }
}

