/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnectionsPool
implements ConnectionsPool<String, Channel> {
    private static final Logger log = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<Channel>> connectionsPool = new ConcurrentHashMap();
    private final AsyncHttpClientConfig config;
    private final NettyAsyncHttpProvider provider;
    private final ConcurrentHashMap<Channel, Timeout> trackedIdleConnections = new ConcurrentHashMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final HashedWheelTimer timer = new HashedWheelTimer();

    public NettyConnectionsPool(NettyAsyncHttpProvider provider) {
        this.provider = provider;
        this.config = provider.getConfig();
    }

    @Override
    public boolean offer(String uri, Channel channel) {
        boolean added;
        if (!this.provider.getConfig().isSslConnectionPoolEnabled() && uri.startsWith("https")) {
            return false;
        }
        log.debug("Adding uri: {} for channel {}", (Object)uri, (Object)channel);
        channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment((Object)new NettyAsyncHttpProvider.DiscardEvent());
        ConcurrentLinkedQueue<Channel> pooledConnectionForHost = this.connectionsPool.get(uri);
        if (pooledConnectionForHost == null) {
            ConcurrentLinkedQueue newPool = new ConcurrentLinkedQueue();
            this.connectionsPool.putIfAbsent(uri, newPool);
            pooledConnectionForHost = this.connectionsPool.get(uri);
        }
        int size = pooledConnectionForHost.size();
        if (this.config.getMaxConnectionPerHost() == -1 || size < this.config.getMaxConnectionPerHost()) {
            added = pooledConnectionForHost.add(channel);
            if (added) {
                Timeout t = this.timer.newTimeout((TimerTask)new IdleRunner(channel, pooledConnectionForHost), (long)this.config.getIdleConnectionInPoolTimeoutInMs(), TimeUnit.MILLISECONDS);
                this.trackedIdleConnections.put(channel, t);
                log.debug("ConnectionsPool increment totalConnections {}", (Object)this.trackedIdleConnections.size());
            }
        } else {
            log.debug("Maximum connections per hosts reached {}", (Object)this.config.getMaxConnectionPerHost());
            added = false;
        }
        return added;
    }

    @Override
    public Channel poll(String uri) {
        if (!this.provider.getConfig().isSslConnectionPoolEnabled() && uri.startsWith("https")) {
            return null;
        }
        Channel channel = null;
        ConcurrentLinkedQueue<Channel> pooledConnectionForHost = this.connectionsPool.get(uri);
        if (pooledConnectionForHost != null) {
            boolean poolEmpty = false;
            while (!poolEmpty && channel == null) {
                if (pooledConnectionForHost.size() > 0) {
                    channel = pooledConnectionForHost.poll();
                }
                if (channel == null) {
                    poolEmpty = true;
                    continue;
                }
                if (!channel.isConnected() || !channel.isOpen()) {
                    this.removeAll(channel);
                    channel = null;
                    continue;
                }
                Timeout idleFuture = this.trackedIdleConnections.remove(channel);
                if (idleFuture != null) {
                    idleFuture.cancel();
                }
                if (!channel.isConnected() || !channel.isOpen()) {
                    channel = null;
                }
                log.debug("ConnectionsPool decrementAndGet totalConnections {}", (Object)this.trackedIdleConnections.size());
            }
        }
        return channel;
    }

    @Override
    public boolean removeAll(Channel channel) {
        if (this.isClosed.get()) {
            return false;
        }
        boolean isRemoved = false;
        for (Map.Entry<String, ConcurrentLinkedQueue<Channel>> e : this.connectionsPool.entrySet()) {
            boolean removed = e.getValue().remove(channel);
            if (removed) {
                log.debug("Removing uri: {} for channel {}", (Object)e.getKey(), e.getValue());
                Timeout idleFuture = this.trackedIdleConnections.remove(channel);
                if (idleFuture != null) {
                    idleFuture.cancel();
                } else {
                    log.debug("ConnectionsPool decrementAndGet totalConnections {}", (Object)this.trackedIdleConnections.size());
                }
            }
            isRemoved |= removed;
        }
        return isRemoved;
    }

    @Override
    public boolean canCacheConnection() {
        return this.config.getMaxTotalConnections() == -1 || this.trackedIdleConnections.size() < this.config.getMaxTotalConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.timer.stop();
        for (Map.Entry<Channel, Timeout> e : this.trackedIdleConnections.entrySet()) {
            this.close(e.getKey());
            e.getValue().cancel();
        }
        this.trackedIdleConnections.clear();
        try {
            Iterator<Map.Entry<String, ConcurrentLinkedQueue<Channel>>> i = this.connectionsPool.entrySet().iterator();
            while (i.hasNext()) {
                for (Channel channel : i.next().getValue()) {
                    this.close(channel);
                }
            }
        }
        finally {
            this.connectionsPool.clear();
        }
    }

    private void close(Channel channel) {
        try {
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment((Object)new NettyAsyncHttpProvider.DiscardEvent());
            channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IdleRunner
    implements TimerTask {
        private final ConcurrentLinkedQueue<Channel> activeChannels;
        private final Channel channel;

        public IdleRunner(Channel channel, ConcurrentLinkedQueue<Channel> activeChannels) {
            this.channel = channel;
            this.activeChannels = activeChannels;
        }

        public void run(Timeout timeout) {
            NettyResponseFuture future;
            if (NettyConnectionsPool.this.isClosed.get()) {
                return;
            }
            Object attachment = this.channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment();
            if (attachment != null && NettyResponseFuture.class.isAssignableFrom(attachment.getClass()) && !(future = (NettyResponseFuture)attachment).isDone() && !future.isCancelled()) {
                log.warn("Future not in appropriate state {}", (Object)future);
                return;
            }
            if (this.activeChannels.remove(this.channel)) {
                log.debug("Channel idle. Expiring {}", (Object)this.channel);
                NettyConnectionsPool.this.close(this.channel);
            }
            timeout.cancel();
        }
    }
}

