/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyResponse
implements Response {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String HEADERS_NOT_COMPUTED = "Response's headers hasn't been computed by your AsyncHandler.";
    private final URI uri;
    private final Collection<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private final List<Cookie> cookies = new ArrayList<Cookie>();

    public NettyResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        this.status = status;
        this.headers = headers;
        this.bodyParts = bodyParts;
        this.uri = status.getUrl();
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(DEFAULT_CHARSET);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        String contentType = this.getContentType();
        if (contentType != null) {
            charset = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        return this.contentToString(charset);
    }

    String contentToString(String charset) throws UnsupportedEncodingException {
        AsyncHttpProviderUtils.checkBodyParts(this.status.getStatusCode(), this.bodyParts);
        StringBuilder b = new StringBuilder();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            b.append(new String(bp.getBodyPartBytes(), charset));
        }
        return b.toString();
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        AsyncHttpProviderUtils.checkBodyParts(this.status.getStatusCode(), this.bodyParts);
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            if (!bp.getClass().isAssignableFrom(ResponseBodyPart.class)) continue;
            buf.writeBytes(bp.getBodyPartBytes());
        }
        return new ChannelBufferInputStream(buf);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, DEFAULT_CHARSET);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        String response;
        AsyncHttpProviderUtils.checkBodyParts(this.status.getStatusCode(), this.bodyParts);
        String contentType = this.getContentType();
        if (contentType != null) {
            charset = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        return (response = this.contentToString(charset)).length() <= maxLength ? response : response.substring(0, maxLength);
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.uri;
    }

    @Override
    public String getContentType() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().getFirstValue("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            throw new IllegalStateException();
        }
        return this.headers.getHeaders().getFirstValue(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders().get(name);
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        return this.headers.getHeaders();
    }

    @Override
    public boolean isRedirected() {
        return this.status.getStatusCode() >= 300 && this.status.getStatusCode() <= 399;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            throw new IllegalStateException(HEADERS_NOT_COMPUTED);
        }
        if (this.cookies.isEmpty()) {
            for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
                if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                List<String> v = header.getValue();
                for (String value : v) {
                    Cookie cookie = AsyncHttpProviderUtils.parseCookie(value);
                    this.cookies.add(cookie);
                }
            }
        }
        return Collections.unmodifiableList(this.cookies);
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null;
    }

    @Override
    public boolean hasResponseBody() {
        return this.bodyParts != null && this.bodyParts.size() > 0;
    }
}

