/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.generators;

import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamBodyGenerator
implements BodyGenerator {
    private final InputStream inputStream;
    private static final Logger logger = LoggerFactory.getLogger(InputStreamBodyGenerator.class);

    public InputStreamBodyGenerator(InputStream inputStream) {
        this.inputStream = inputStream;
        if (inputStream.markSupported()) {
            inputStream.mark(0);
        } else {
            logger.warn("inputStream.markSupported() not supported. Some features will not works");
        }
    }

    public Body createBody() throws IOException {
        return new ISBody();
    }

    protected class ISBody
    implements Body {
        private boolean eof = false;
        private byte[] chunk;

        protected ISBody() {
        }

        public long getContentLength() {
            return -1L;
        }

        public long read(ByteBuffer buffer) throws IOException {
            this.chunk = new byte[buffer.capacity() - 10];
            int read = -1;
            try {
                read = InputStreamBodyGenerator.this.inputStream.read(this.chunk);
            }
            catch (IOException ex) {
                logger.warn("Unable to read", (Throwable)ex);
            }
            if (read == -1) {
                if (!this.eof) {
                    this.eof = true;
                    buffer.put("0".getBytes("UTF-8"));
                    buffer.put("\n".getBytes("UTF-8"));
                    return buffer.position();
                }
                if (InputStreamBodyGenerator.this.inputStream.markSupported()) {
                    InputStreamBodyGenerator.this.inputStream.reset();
                }
                this.eof = false;
                return -1L;
            }
            buffer.put(Integer.toHexString(read).getBytes("UTF-8"));
            buffer.put("\n".getBytes("UTF-8"));
            buffer.put(this.chunk, 0, read);
            return read;
        }

        public void close() throws IOException {
            InputStreamBodyGenerator.this.inputStream.close();
        }
    }
}

