/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.Part;
import com.ning.http.multipart.ByteArrayPartSource;
import com.ning.http.multipart.FilePart;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.multipart.StringPart;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpProviderUtils {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String BODY_NOT_COMPUTED = "Response's body hasn't been computed by your AsyncHandler.";
    private static final SimpleDateFormat[] RFC2822_LIKE_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US), new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss Z", Locale.US)};
    static final byte SP = 32;
    static final byte HT = 9;
    static final byte CR = 13;
    static final byte EQUALS = 61;
    static final byte LF = 10;
    static final byte[] CRLF = new byte[]{13, 10};
    static final byte COLON = 58;
    static final byte SEMICOLON = 59;
    static final byte COMMA = 44;
    static final byte DOUBLE_QUOTE = 34;
    static final String PATH = "Path";
    static final String EXPIRES = "Expires";
    static final String MAX_AGE = "Max-Age";
    static final String DOMAIN = "Domain";
    static final String SECURE = "Secure";
    static final String HTTPONLY = "HTTPOnly";
    static final String COMMENT = "Comment";
    static final String COMMENTURL = "CommentURL";
    static final String DISCARD = "Discard";
    static final String PORT = "Port";
    static final String VERSION = "Version";

    public static final URI createUri(String u) {
        URI uri = URI.create(u);
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + u + ", must be equal (ignoring case) to 'http' or 'https'");
        }
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ", must be non-null");
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + uri + ". must start with a '/'");
        }
        if (path.length() == 0) {
            return URI.create(u + "/");
        }
        return uri;
    }

    public static final String getBaseUrl(URI uri) {
        String url = uri.getScheme() + "://" + uri.getAuthority();
        int port = uri.getPort();
        if (port == -1) {
            port = AsyncHttpProviderUtils.getPort(uri);
            url = url + ":" + port;
        }
        return url;
    }

    public static final String getAuthority(URI uri) {
        String url = uri.getAuthority();
        int port = uri.getPort();
        if (port == -1) {
            port = AsyncHttpProviderUtils.getPort(uri);
            url = url + ":" + port;
        }
        return url;
    }

    public static final URI getRedirectUri(URI uri, String location) {
        URI newUri = uri.resolve(location);
        String scheme = newUri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + newUri + ", must be equal (ignoring case) to 'http' or 'https'");
        }
        return newUri;
    }

    public static final int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().equals("http") ? 80 : 443;
        }
        return port;
    }

    public static final MultipartRequestEntity createMultipartRequestEntity(List<Part> params, FluentStringsMap methodParams) throws FileNotFoundException {
        com.ning.http.multipart.Part[] parts = new com.ning.http.multipart.Part[params.size()];
        int i = 0;
        for (Part part : params) {
            if (part instanceof com.ning.http.client.StringPart) {
                parts[i] = new StringPart(part.getName(), ((com.ning.http.client.StringPart)part).getValue(), "UTF-8");
            } else if (part instanceof com.ning.http.client.FilePart) {
                parts[i] = new FilePart(part.getName(), ((com.ning.http.client.FilePart)part).getFile(), ((com.ning.http.client.FilePart)part).getMimeType(), ((com.ning.http.client.FilePart)part).getCharSet());
            } else if (part instanceof ByteArrayPart) {
                ByteArrayPartSource source = new ByteArrayPartSource(((ByteArrayPart)part).getFileName(), ((ByteArrayPart)part).getData());
                parts[i] = new FilePart(part.getName(), source, ((ByteArrayPart)part).getMimeType(), ((ByteArrayPart)part).getCharSet());
            } else {
                if (part == null) {
                    throw new NullPointerException("Part cannot be null");
                }
                throw new IllegalArgumentException(String.format("Unsupported part type for multipart parameter %s", part.getName()));
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, methodParams);
    }

    public static final byte[] readFully(InputStream in, int[] lengthWrapper) throws IOException {
        int left;
        int count;
        byte[] b = new byte[Math.max(512, in.available())];
        int offset = 0;
        while ((count = in.read(b, offset, left = b.length - offset)) >= 0) {
            offset += count;
            if (count != left) continue;
            b = AsyncHttpProviderUtils.doubleUp(b);
        }
        lengthWrapper[0] = offset;
        return b;
    }

    private static byte[] doubleUp(byte[] b) {
        int len = b.length;
        byte[] b2 = new byte[len + len];
        System.arraycopy(b, 0, b2, 0, len);
        return b2;
    }

    public static String encodeCookies(Collection<Cookie> cookies) {
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : cookies) {
            if (cookie.getVersion() >= 1) {
                AsyncHttpProviderUtils.add(sb, "$Version", 1);
            }
            AsyncHttpProviderUtils.add(sb, cookie.getName(), cookie.getValue());
            if (cookie.getPath() != null) {
                AsyncHttpProviderUtils.add(sb, "$Path", cookie.getPath());
            }
            if (cookie.getDomain() != null) {
                AsyncHttpProviderUtils.add(sb, "$Domain", cookie.getDomain());
            }
            if (cookie.getVersion() < 1 || cookie.getPorts().isEmpty()) continue;
            sb.append('$');
            sb.append(PORT);
            sb.append('=');
            sb.append('\"');
            for (int port : cookie.getPorts()) {
                sb.append(port);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, '\"');
            sb.append(';');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static void add(StringBuilder sb, String name, String val) {
        if (val == null) {
            AsyncHttpProviderUtils.addQuoted(sb, name, "");
            return;
        }
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    AsyncHttpProviderUtils.addQuoted(sb, name, val);
                    return;
                }
            }
        }
        AsyncHttpProviderUtils.addUnquoted(sb, name, val);
    }

    private static void addUnquoted(StringBuilder sb, String name, String val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
    }

    private static void addQuoted(StringBuilder sb, String name, String val) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        sb.append('\"');
        sb.append(val.replace("\\", "\\\\").replace("\"", "\\\""));
        sb.append('\"');
        sb.append(';');
    }

    private static void add(StringBuilder sb, String name, int val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
    }

    public static String constructUserAgent(Class<? extends AsyncHttpProvider> httpProvider) {
        StringBuffer b = new StringBuffer("AsyncHttpClient/1.0").append(" ").append("(").append(httpProvider.getSimpleName()).append(" - ").append(System.getProperty("os.name")).append(" - ").append(System.getProperty("os.version")).append(" - ").append(System.getProperty("java.version")).append(" - ").append(Runtime.getRuntime().availableProcessors()).append(" core(s))");
        return b.toString();
    }

    public static String parseCharset(String contentType) {
        for (String part : contentType.split(";")) {
            String[] val;
            if (!part.trim().startsWith("charset=") || (val = part.split("="))[1] == null) continue;
            return val[1].trim();
        }
        return null;
    }

    public static Cookie parseCookie(String value) {
        String[] fields = value.split(";\\s*");
        String[] cookie = fields[0].split("=");
        String cookieName = cookie[0];
        String cookieValue = cookie[1];
        int maxAge = -1;
        String path = null;
        String domain = null;
        boolean secure = false;
        boolean maxAgeSet = false;
        boolean expiresSet = false;
        for (int j = 1; j < fields.length; ++j) {
            if ("secure".equalsIgnoreCase(fields[j])) {
                secure = true;
                continue;
            }
            if (fields[j].indexOf(61) <= 0) continue;
            String[] f = fields[j].split("=");
            if (!maxAgeSet && "max-age".equalsIgnoreCase(f[0])) {
                try {
                    maxAge = Integer.valueOf(f[1]);
                }
                catch (NumberFormatException e1) {
                    maxAge = -1;
                }
                maxAgeSet = true;
                continue;
            }
            if (!maxAgeSet && !expiresSet && "expires".equalsIgnoreCase(f[0])) {
                try {
                    maxAge = AsyncHttpProviderUtils.convertExpireField(f[1]);
                }
                catch (ParseException e) {
                    try {
                        maxAge = Integer.valueOf(f[1]);
                    }
                    catch (NumberFormatException e1) {
                        // empty catch block
                    }
                }
                expiresSet = true;
                continue;
            }
            if ("domain".equalsIgnoreCase(f[0])) {
                domain = f[1];
                continue;
            }
            if (!"path".equalsIgnoreCase(f[0])) continue;
            path = f[1];
        }
        return new Cookie(domain, cookieName, cookieValue, path, maxAge, secure);
    }

    private static int convertExpireField(String timestring) throws ParseException {
        ParseException exception = null;
        for (SimpleDateFormat sdf : RFC2822_LIKE_DATE_FORMATS) {
            try {
                long expire = sdf.parse(timestring).getTime();
                return (int)(expire - System.currentTimeMillis()) / 1000;
            }
            catch (ParseException e) {
                exception = e;
            }
        }
        throw exception;
    }

    public static void checkBodyParts(int statusCode, Collection<HttpResponseBodyPart> bodyParts) {
        if (bodyParts == null || bodyParts.size() == 0) {
            if (statusCode == 204) {
                return;
            }
            throw new IllegalStateException(BODY_NOT_COMPUTED);
        }
    }
}

