/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.providers.netty.netty4.BinaryWebSocketFrame;
import com.ning.http.client.providers.netty.netty4.TextWebSocketFrame;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;

public class NettyWebSocket
implements WebSocket {
    private final Channel channel;
    private final ConcurrentLinkedQueue<WebSocketListener> listeners = new ConcurrentLinkedQueue();

    public NettyWebSocket(Channel channel) {
        this.channel = channel;
    }

    @Override
    public WebSocket sendMessage(byte[] message) {
        this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])message)));
        return this;
    }

    @Override
    public WebSocket sendTextMessage(String message) {
        this.channel.write((Object)new TextWebSocketFrame(message));
        return this;
    }

    @Override
    public WebSocket addMessageListener(WebSocketListener l) {
        this.listeners.add(l);
        return this;
    }

    @Override
    public void close() {
        this.onClose();
        this.channel.close();
    }

    protected void onMessage(byte[] message) {
        for (WebSocketListener l : this.listeners) {
            if (!WebSocketByteListener.class.isAssignableFrom(l.getClass())) continue;
            ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onMessage(message);
        }
    }

    protected void onTextMessage(String message) {
        for (WebSocketListener l : this.listeners) {
            if (!WebSocketTextListener.class.isAssignableFrom(l.getClass())) continue;
            ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onMessage(message);
        }
    }

    protected void onError(Throwable t) {
        for (WebSocketListener l : this.listeners) {
            l.onError(t);
        }
    }

    protected void onClose() {
        for (WebSocketListener l : this.listeners) {
            l.onClose(this);
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }
}

