/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.Body;
import com.ning.http.client.BodyGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;

public class FeedableBodyGenerator
implements BodyGenerator {
    private final Queue<BodyPart> queue = new ConcurrentLinkedQueue<BodyPart>();
    private final AtomicInteger queueSize = new AtomicInteger();
    private volatile HttpRequestPacket requestPacket;
    private volatile FilterChainContext context;

    @Override
    public Body createBody() throws IOException {
        return new EmptyBody();
    }

    public void feed(Buffer buffer, boolean isLast) throws IOException {
        this.queue.offer(new BodyPart(buffer, isLast));
        this.queueSize.incrementAndGet();
        if (this.context != null) {
            this.flushQueue();
        }
    }

    void initializeAsynchronousTransfer(FilterChainContext context, HttpRequestPacket requestPacket) throws IOException {
        this.context = context;
        this.requestPacket = requestPacket;
        this.flushQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushQueue() throws IOException {
        if (this.queueSize.get() > 0) {
            FeedableBodyGenerator feedableBodyGenerator = this;
            synchronized (feedableBodyGenerator) {
                while (this.queueSize.get() > 0) {
                    BodyPart bodyPart = this.queue.poll();
                    this.queueSize.decrementAndGet();
                    HttpContent content = this.requestPacket.httpContentBuilder().content(bodyPart.buffer).last(bodyPart.isLast).build();
                    this.context.write((Object)content, !this.requestPacket.isCommitted() ? this.context.getTransportContext().getCompletionHandler() : null);
                }
            }
        }
    }

    private static final class BodyPart {
        private final boolean isLast;
        private final Buffer buffer;

        public BodyPart(Buffer buffer, boolean isLast) {
            this.buffer = buffer;
            this.isLast = isLast;
        }
    }

    private final class EmptyBody
    implements Body {
        private EmptyBody() {
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public long read(ByteBuffer buffer) throws IOException {
            return 0L;
        }

        @Override
        public void close() throws IOException {
            FeedableBodyGenerator.this.context.completeAndRecycle();
            FeedableBodyGenerator.this.context = null;
            FeedableBodyGenerator.this.requestPacket = null;
        }
    }
}

