/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Cookies;
import org.glassfish.grizzly.http.CookiesBuilder;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferInputStream;
import org.glassfish.grizzly.utils.Charsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyResponse
implements Response {
    private final HttpResponseStatus status;
    private final HttpResponseHeaders headers;
    private final Collection<HttpResponseBodyPart> bodyParts;
    private final Buffer responseBody;
    private List<Cookie> cookies;

    public GrizzlyResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        this.status = status;
        this.headers = headers;
        this.bodyParts = bodyParts;
        if (bodyParts != null && !bodyParts.isEmpty()) {
            HttpResponseBodyPart[] parts = bodyParts.toArray(new HttpResponseBodyPart[bodyParts.size()]);
            if (parts.length == 1) {
                this.responseBody = ((GrizzlyResponseBodyPart)parts[0]).getBodyBuffer();
            } else {
                Buffer firstBuffer = ((GrizzlyResponseBodyPart)parts[0]).getBodyBuffer();
                MemoryManager mm = MemoryManager.DEFAULT_MEMORY_MANAGER;
                Buffer constructedBodyBuffer = firstBuffer;
                int len = parts.length;
                for (int i = 1; i < len; ++i) {
                    constructedBodyBuffer = Buffers.appendBuffers((MemoryManager)mm, (Buffer)constructedBodyBuffer, (Buffer)((GrizzlyResponseBodyPart)parts[i]).getBodyBuffer());
                }
                this.responseBody = constructedBodyBuffer;
            }
        } else {
            this.responseBody = Buffers.EMPTY_BUFFER;
        }
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return new BufferInputStream(this.responseBody);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        int len = Math.min(this.responseBody.remaining(), maxLength);
        int pos = this.responseBody.position();
        return this.responseBody.toStringContent(this.getCharset(charset), pos, len + pos);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        return this.responseBody.toStringContent(this.getCharset(charset));
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, null);
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(Charsets.DEFAULT_CHARACTER_ENCODING);
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return this.getResponseBody().getBytes(Charsets.DEFAULT_CHARACTER_ENCODING);
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.status.getUrl();
    }

    @Override
    public String getContentType() {
        return this.headers.getHeaders().getFirstValue("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeaders().getFirstValue(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders().get(name);
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers.getHeaders();
    }

    @Override
    public boolean isRedirected() {
        return this.between(this.status.getStatusCode(), 300, 399);
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            Object values = this.headers.getHeaders().get("set-cookie");
            if (values != null && !values.isEmpty()) {
                CookiesBuilder.ServerCookiesBuilder builder = new CookiesBuilder.ServerCookiesBuilder(false);
                Iterator i$ = values.iterator();
                while (i$.hasNext()) {
                    String header = (String)i$.next();
                    builder.parse(header);
                }
                this.cookies = this.convertCookies(builder.build());
            } else {
                this.cookies = Collections.emptyList();
            }
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null && !this.headers.getHeaders().isEmpty();
    }

    @Override
    public boolean hasResponseBody() {
        return this.bodyParts != null && !this.bodyParts.isEmpty();
    }

    private List<Cookie> convertCookies(Cookies cookies) {
        org.glassfish.grizzly.http.Cookie[] grizzlyCookies = cookies.get();
        ArrayList<Cookie> convertedCookies = new ArrayList<Cookie>(grizzlyCookies.length);
        for (org.glassfish.grizzly.http.Cookie gCookie : grizzlyCookies) {
            convertedCookies.add(new Cookie(gCookie.getDomain(), gCookie.getName(), gCookie.getValue(), gCookie.getPath(), gCookie.getMaxAge(), gCookie.isSecure(), gCookie.getVersion()));
        }
        return Collections.unmodifiableList(convertedCookies);
    }

    private Charset getCharset(String charset) {
        String contentType;
        String charsetLocal = charset;
        if (charsetLocal == null && (contentType = this.getContentType()) != null) {
            charsetLocal = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        if (charsetLocal == null) {
            charsetLocal = Charsets.DEFAULT_CHARACTER_ENCODING;
        }
        return Charsets.lookupCharset((String)charsetLocal);
    }

    private boolean between(int value, int lowerBound, int upperBound) {
        return value >= lowerBound && value <= upperBound;
    }
}

