/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyResponse
implements Response {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private final URI uri;
    private final Collection<HttpResponseBodyPart> bodyParts;
    private final HttpResponseHeaders headers;
    private final HttpResponseStatus status;
    private List<Cookie> cookies;

    public NettyResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        this.status = status;
        this.headers = headers;
        this.bodyParts = bodyParts;
        this.uri = status.getUrl();
    }

    @Override
    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        return AsyncHttpProviderUtils.contentToByte(this.bodyParts);
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(null);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        return AsyncHttpProviderUtils.contentToString(this.bodyParts, this.computeCharset(charset));
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        for (HttpResponseBodyPart bp : this.bodyParts) {
            if (!bp.getClass().isAssignableFrom(ResponseBodyPart.class)) continue;
            buf.writeBytes(bp.getBodyPartBytes());
        }
        return new ChannelBufferInputStream(buf);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, null);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        String response = AsyncHttpProviderUtils.contentToString(this.bodyParts, this.computeCharset(charset));
        return response.length() <= maxLength ? response : response.substring(0, maxLength);
    }

    private String computeCharset(String charset) {
        String contentType;
        if (charset == null && (contentType = this.getContentType()) != null) {
            charset = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        return charset != null ? charset : DEFAULT_CHARSET;
    }

    @Override
    public URI getUri() throws MalformedURLException {
        return this.uri;
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.headers != null ? this.headers.getHeaders().getFirstValue(name) : null;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers != null ? this.headers.getHeaders().get(name) : Collections.emptyList();
    }

    @Override
    public FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers != null ? this.headers.getHeaders() : new FluentCaseInsensitiveStringsMap();
    }

    @Override
    public boolean isRedirected() {
        return this.status.getStatusCode() >= 300 && this.status.getStatusCode() <= 399;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            ArrayList<Cookie> localCookies = new ArrayList<Cookie>();
            for (Map.Entry<String, List<String>> header : this.headers.getHeaders().entrySet()) {
                if (!header.getKey().equalsIgnoreCase("Set-Cookie")) continue;
                List<String> v = header.getValue();
                for (String value : v) {
                    Cookie cookie = AsyncHttpProviderUtils.parseCookie(value);
                    localCookies.add(cookie);
                }
            }
            this.cookies = Collections.unmodifiableList(localCookies);
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null;
    }

    @Override
    public boolean hasResponseBody() {
        return this.bodyParts != null && !this.bodyParts.isEmpty();
    }
}

