/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketCloseCodeReasonListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
implements WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebSocket.class);
    private final Channel channel;
    private final ConcurrentLinkedQueue<WebSocketListener> listeners = new ConcurrentLinkedQueue();
    private StringBuilder textBuffer;
    private ByteArrayOutputStream byteBuffer;
    private int maxBufferSize = 128000000;

    public NettyWebSocket(Channel channel) {
        this.channel = channel;
    }

    public WebSocket sendMessage(byte[] message) {
        this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])message)));
        return this;
    }

    public WebSocket stream(byte[] fragment, boolean last) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket sendTextMessage(String message) {
        this.channel.write((Object)new TextWebSocketFrame(message));
        return this;
    }

    public WebSocket streamText(String fragment, boolean last) {
        throw new UnsupportedOperationException("Streaming currently only supported by the Grizzly provider.");
    }

    public WebSocket sendPing(byte[] payload) {
        this.channel.write((Object)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public WebSocket sendPong(byte[] payload) {
        this.channel.write((Object)new PongWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        return this;
    }

    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        return this;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int bufferSize) {
        this.maxBufferSize = bufferSize;
        if (this.maxBufferSize < 8192) {
            this.maxBufferSize = 8192;
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.onClose();
        this.listeners.clear();
        try {
            this.channel.write((Object)new CloseWebSocketFrame());
            this.channel.getCloseFuture().awaitUninterruptibly();
        }
        finally {
            this.channel.close();
        }
    }

    protected void onBinaryFragment(byte[] message, boolean last) {
        for (WebSocketListener l : this.listeners) {
            if (!WebSocketByteListener.class.isAssignableFrom(l.getClass())) continue;
            try {
                ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onFragment(message, last);
                if (this.byteBuffer == null) {
                    this.byteBuffer = new ByteArrayOutputStream();
                }
                this.byteBuffer.write(message);
                if (this.byteBuffer.size() > this.maxBufferSize) {
                    Exception e = new Exception("Exceeded Netty Web Socket maximum buffer size of " + this.getMaxBufferSize());
                    l.onError(e);
                    this.close();
                    return;
                }
                if (!last) continue;
                ((WebSocketByteListener)WebSocketByteListener.class.cast(l)).onMessage(this.byteBuffer.toByteArray());
                this.byteBuffer = null;
                this.textBuffer = null;
            }
            catch (Exception ex) {
                l.onError(ex);
            }
        }
    }

    protected void onTextFragment(String message, boolean last) {
        for (WebSocketListener l : this.listeners) {
            if (!WebSocketTextListener.class.isAssignableFrom(l.getClass())) continue;
            try {
                ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onFragment(message, last);
                if (this.textBuffer == null) {
                    this.textBuffer = new StringBuilder();
                }
                this.textBuffer.append(message);
                if (this.textBuffer.length() > this.maxBufferSize) {
                    Exception e = new Exception("Exceeded Netty Web Socket maximum buffer size of " + this.getMaxBufferSize());
                    l.onError(e);
                    this.close();
                    return;
                }
                if (!last) continue;
                ((WebSocketTextListener)WebSocketTextListener.class.cast(l)).onMessage(this.textBuffer.toString());
                this.byteBuffer = null;
                this.textBuffer = null;
            }
            catch (Exception ex) {
                l.onError(ex);
            }
        }
    }

    protected void onError(Throwable t) {
        for (WebSocketListener l : this.listeners) {
            try {
                l.onError(t);
            }
            catch (Throwable t2) {
                logger.error("", t2);
            }
        }
    }

    protected void onClose() {
        this.onClose(1000, "Normal closure; the connection successfully completed whatever purpose for which it was created.");
    }

    protected void onClose(int code, String reason) {
        for (WebSocketListener l : this.listeners) {
            try {
                if (WebSocketCloseCodeReasonListener.class.isAssignableFrom(l.getClass())) {
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(l)).onClose(this, code, reason);
                }
                l.onClose(this);
            }
            catch (Throwable t) {
                l.onError(t);
            }
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }
}

