/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.util.DateUtils;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnectionsPool
implements ConnectionsPool<String, Channel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectionsPool.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<IdleChannel>> connectionsPool = new ConcurrentHashMap();
    private final ConcurrentHashMap<Channel, IdleChannel> channel2IdleChannel = new ConcurrentHashMap();
    private final ConcurrentHashMap<Channel, Long> channel2CreationDate = new ConcurrentHashMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Timer nettyTimer;
    private final boolean sslConnectionPoolEnabled;
    private final int maxTotalConnections;
    private final int maxConnectionPerHost;
    private final int maxConnectionLifeTimeInMs;
    private final long maxIdleTime;

    public NettyConnectionsPool(NettyAsyncHttpProvider provider, Timer hashedWheelTimer) {
        this(provider.getConfig().getMaxTotalConnections(), provider.getConfig().getMaxConnectionPerHost(), provider.getConfig().getIdleConnectionInPoolTimeoutInMs(), provider.getConfig().getMaxConnectionLifeTimeInMs(), provider.getConfig().isSslConnectionPoolEnabled(), hashedWheelTimer);
    }

    public NettyConnectionsPool(int maxTotalConnections, int maxConnectionPerHost, long maxIdleTime, int maxConnectionLifeTimeInMs, boolean sslConnectionPoolEnabled, Timer nettyTimer) {
        this.maxTotalConnections = maxTotalConnections;
        this.maxConnectionPerHost = maxConnectionPerHost;
        this.sslConnectionPoolEnabled = sslConnectionPoolEnabled;
        this.maxIdleTime = maxIdleTime;
        this.maxConnectionLifeTimeInMs = maxConnectionLifeTimeInMs;
        this.nettyTimer = nettyTimer;
        if (maxIdleTime > 0L) {
            this.scheduleNewIdleChannelDetector(new IdleChannelDetector());
        }
    }

    private void scheduleNewIdleChannelDetector(TimerTask task) {
        this.nettyTimer.newTimeout(task, this.maxIdleTime, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(String uri, Channel channel) {
        boolean added;
        ConcurrentLinkedQueue newPool;
        if (this.isClosed.get() || !this.sslConnectionPoolEnabled && uri.startsWith("https")) {
            return false;
        }
        Long createTime = this.channel2CreationDate.get(channel);
        if (createTime == null) {
            this.channel2CreationDate.putIfAbsent(channel, DateUtils.millisTime());
        } else if (this.maxConnectionLifeTimeInMs != -1 && createTime + (long)this.maxConnectionLifeTimeInMs < DateUtils.millisTime()) {
            LOGGER.debug("Channel {} expired", (Object)channel);
            return false;
        }
        LOGGER.debug("Adding uri: {} for channel {}", (Object)uri, (Object)channel);
        channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment((Object)new NettyAsyncHttpProvider.DiscardEvent());
        ConcurrentLinkedQueue<IdleChannel> idleConnectionForHost = this.connectionsPool.get(uri);
        if (idleConnectionForHost == null && (idleConnectionForHost = this.connectionsPool.putIfAbsent(uri, newPool = new ConcurrentLinkedQueue())) == null) {
            idleConnectionForHost = newPool;
        }
        int size = idleConnectionForHost.size();
        if (this.maxConnectionPerHost == -1 || size < this.maxConnectionPerHost) {
            IdleChannel idleChannel = new IdleChannel(uri, channel);
            ConcurrentLinkedQueue<IdleChannel> concurrentLinkedQueue = idleConnectionForHost;
            synchronized (concurrentLinkedQueue) {
                added = idleConnectionForHost.add(idleChannel);
                if (this.channel2IdleChannel.put(channel, idleChannel) != null) {
                    LOGGER.error("Channel {} already exists in the connections pool!", (Object)channel);
                }
            }
        } else {
            LOGGER.debug("Maximum number of requests per host reached {} for {}", (Object)this.maxConnectionPerHost, (Object)uri);
            added = false;
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel poll(String uri) {
        if (!this.sslConnectionPoolEnabled && uri.startsWith("https")) {
            return null;
        }
        IdleChannel idleChannel = null;
        ConcurrentLinkedQueue<IdleChannel> pooledConnectionForKey = this.connectionsPool.get(uri);
        if (pooledConnectionForKey != null) {
            boolean poolEmpty = false;
            while (!poolEmpty && idleChannel == null) {
                if (!pooledConnectionForKey.isEmpty()) {
                    ConcurrentLinkedQueue<IdleChannel> concurrentLinkedQueue = pooledConnectionForKey;
                    synchronized (concurrentLinkedQueue) {
                        idleChannel = pooledConnectionForKey.poll();
                        if (idleChannel != null) {
                            this.channel2IdleChannel.remove(idleChannel.channel);
                        }
                    }
                }
                if (idleChannel == null) {
                    poolEmpty = true;
                    continue;
                }
                if (idleChannel.channel.isConnected() && idleChannel.channel.isOpen()) continue;
                idleChannel = null;
                LOGGER.trace("Channel not connected or not opened!");
            }
        }
        return idleChannel != null ? idleChannel.channel : null;
    }

    private boolean remove(IdleChannel pooledChannel) {
        if (pooledChannel == null || this.isClosed.get()) {
            return false;
        }
        boolean isRemoved = false;
        ConcurrentLinkedQueue<IdleChannel> pooledConnectionForKey = this.connectionsPool.get(pooledChannel.key);
        if (pooledConnectionForKey != null) {
            isRemoved = pooledConnectionForKey.remove(pooledChannel);
        }
        return isRemoved |= this.channel2IdleChannel.remove(pooledChannel.channel) != null;
    }

    @Override
    public boolean removeAll(Channel channel) {
        this.channel2CreationDate.remove(channel);
        return !this.isClosed.get() && this.remove(this.channel2IdleChannel.get(channel));
    }

    @Override
    public boolean canCacheConnection() {
        return !this.isClosed.get() && (this.maxTotalConnections == -1 || this.channel2IdleChannel.size() < this.maxTotalConnections);
    }

    @Override
    public void destroy() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        for (Channel channel : this.channel2IdleChannel.keySet()) {
            this.close(channel);
        }
        this.connectionsPool.clear();
        this.channel2IdleChannel.clear();
        this.channel2CreationDate.clear();
    }

    private void close(Channel channel) {
        try {
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment((Object)new NettyAsyncHttpProvider.DiscardEvent());
            this.channel2CreationDate.remove(channel);
            channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final String toString() {
        return String.format("NettyConnectionPool: {pool-size: %d}", this.channel2IdleChannel.size());
    }

    private class IdleChannelDetector
    implements TimerTask {
        private IdleChannelDetector() {
        }

        public void run(Timeout timeout) throws Exception {
            try {
                if (NettyConnectionsPool.this.isClosed.get()) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    Set keys = NettyConnectionsPool.this.connectionsPool.keySet();
                    for (String s : keys) {
                        LOGGER.debug("Entry count for : {} : {}", (Object)s, (Object)((ConcurrentLinkedQueue)NettyConnectionsPool.this.connectionsPool.get(s)).size());
                    }
                }
                ArrayList<IdleChannel> channelsInTimeout = new ArrayList<IdleChannel>();
                long currentTime = DateUtils.millisTime();
                for (IdleChannel idleChannel : NettyConnectionsPool.this.channel2IdleChannel.values()) {
                    long age = currentTime - idleChannel.start;
                    if (age <= NettyConnectionsPool.this.maxIdleTime) continue;
                    LOGGER.debug("Adding Candidate Idle Channel {}", (Object)idleChannel.channel);
                    channelsInTimeout.add(idleChannel);
                }
                long endConcurrentLoop = DateUtils.millisTime();
                for (IdleChannel idleChannel : channelsInTimeout) {
                    NettyResponseFuture future;
                    Object attachment = idleChannel.channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment();
                    if (attachment instanceof NettyResponseFuture && !(future = (NettyResponseFuture)attachment).isDone() && !future.isCancelled()) {
                        LOGGER.debug("Future not in appropriate state %s\n", (Object)future);
                        continue;
                    }
                    if (!NettyConnectionsPool.this.remove(idleChannel)) continue;
                    LOGGER.debug("Closing Idle Channel {}", (Object)idleChannel.channel);
                    NettyConnectionsPool.this.close(idleChannel.channel);
                }
                if (LOGGER.isTraceEnabled()) {
                    int openChannels = 0;
                    for (ConcurrentLinkedQueue hostChannels : NettyConnectionsPool.this.connectionsPool.values()) {
                        openChannels += hostChannels.size();
                    }
                    LOGGER.trace(String.format("%d channel open, %d idle channels closed (times: 1st-loop=%d, 2nd-loop=%d).\n", openChannels, channelsInTimeout.size(), endConcurrentLoop - currentTime, DateUtils.millisTime() - endConcurrentLoop));
                }
            }
            catch (Throwable t) {
                LOGGER.error("uncaught exception!", t);
            }
            NettyConnectionsPool.this.scheduleNewIdleChannelDetector(timeout.getTask());
        }
    }

    private static final class IdleChannel {
        final String key;
        final Channel channel;
        final long start;

        IdleChannel(String key, Channel channel) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (channel == null) {
                throw new NullPointerException("channel");
            }
            this.key = key;
            this.channel = channel;
            this.start = DateUtils.millisTime();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IdleChannel && this.channel.equals(((IdleChannel)IdleChannel.class.cast((Object)o)).channel);
        }

        public int hashCode() {
            return this.channel != null ? this.channel.hashCode() : 0;
        }
    }
}

