/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request;

import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.future.StackTraceInspector;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.ning.http.util.Base64;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyConnectListener<T>
implements ChannelFutureListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final AsyncHttpClientConfig config;
    private final NettyResponseFuture<T> future;
    private final NettyRequestSender requestSender;
    private final ChannelManager channelManager;
    private final boolean channelPreempted;
    private final String poolKey;

    public NettyConnectListener(AsyncHttpClientConfig config, NettyResponseFuture<T> future, NettyRequestSender requestSender, ChannelManager channelManager, boolean channelPreempted, String poolKey) {
        this.config = config;
        this.future = future;
        this.requestSender = requestSender;
        this.channelManager = channelManager;
        this.channelPreempted = channelPreempted;
        this.poolKey = poolKey;
    }

    public NettyResponseFuture<T> future() {
        return this.future;
    }

    private void abortChannelPreemption(String poolKey) {
        if (this.channelPreempted) {
            this.channelManager.abortChannelPreemption(poolKey);
        }
    }

    private void writeRequest(Channel channel, String poolKey) {
        LOGGER.debug("Request using non cached Channel '{}':\n{}\n", (Object)channel, (Object)this.future.getNettyRequest().getHttpRequest());
        if (this.future.isDone()) {
            this.abortChannelPreemption(poolKey);
            return;
        }
        if (this.future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(this.future.getAsyncHandler())).onConnectionOpen();
        }
        this.channelManager.registerOpenChannel(channel);
        this.future.attachChannel(channel, false);
        this.requestSender.writeRequest(this.future, channel);
    }

    public final void operationComplete(ChannelFuture f) throws Exception {
        Channel channel = f.getChannel();
        if (f.isSuccess()) {
            Channels.setAttribute(channel, this.future);
            final SslHandler sslHandler = ChannelManager.getSslHandler(channel.getPipeline());
            final HostnameVerifier hostnameVerifier = this.config.getHostnameVerifier();
            if (hostnameVerifier != null && sslHandler != null) {
                final String host = this.future.getURI().getHost();
                sslHandler.handshake().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture handshakeFuture) throws Exception {
                        if (handshakeFuture.isSuccess()) {
                            Channel channel = handshakeFuture.getChannel();
                            SSLEngine engine = sslHandler.getEngine();
                            SSLSession session = engine.getSession();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("onFutureSuccess: session = {}, id = {}, isValid = {}, host = {}", new Object[]{session.toString(), Base64.encode(session.getId()), session.isValid(), host});
                            }
                            if (hostnameVerifier.verify(host, session)) {
                                NettyConnectListener.this.writeRequest(channel, NettyConnectListener.this.poolKey);
                            } else {
                                NettyConnectListener.this.abortChannelPreemption(NettyConnectListener.this.poolKey);
                                ConnectException exception = new ConnectException("HostnameVerifier exception");
                                NettyConnectListener.this.future.abort(exception);
                                throw exception;
                            }
                        }
                    }
                });
            } else {
                this.writeRequest(f.getChannel(), this.poolKey);
            }
        } else {
            this.abortChannelPreemption(this.poolKey);
            Throwable cause = f.getCause();
            boolean canRetry = this.future.canRetry();
            LOGGER.debug("Trying to recover a dead cached channel {} with a retry value of {} ", (Object)f.getChannel(), (Object)canRetry);
            if (canRetry && cause != null && (cause instanceof ClosedChannelException || this.future.getState() != NettyResponseFuture.STATE.NEW || StackTraceInspector.abortOnDisconnectException(cause)) && !this.requestSender.retry(this.future)) {
                return;
            }
            LOGGER.debug("Failed to recover from exception: {} with channel {}", (Object)cause, (Object)f.getChannel());
            boolean printCause = f.getCause() != null && cause.getMessage() != null;
            ConnectException e = new ConnectException(printCause ? cause.getMessage() + " to " + this.future.getURI().toString() : this.future.getURI().toString());
            if (cause != null) {
                e.initCause(cause);
            }
            this.future.abort(e);
        }
    }
}

